/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DefaultDiagFormat;
import org.xbib.z3950.common.v3.DiagRec;
import org.xbib.z3950.common.v3.NamePlusRecord;

public final class Records
extends ASN1Any {
    public NamePlusRecord[] c_responseRecords;
    public DefaultDiagFormat c_nonSurrogateDiagnostic;
    public DiagRec[] c_multipleNonSurDiagnostics;

    public Records(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_responseRecords = null;
        this.c_nonSurrogateDiagnostic = null;
        this.c_multipleNonSurDiagnostics = null;
        if (ber.getTag() == 28 && ber.getTagType() == 128) {
            BERConstructed berConstructed;
            BEREncoding ber_data = ber;
            try {
                berConstructed = (BERConstructed)ber_data;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Records: bad BER form\n");
            }
            int numParts = berConstructed.numberComponents();
            this.c_responseRecords = new NamePlusRecord[numParts];
            for (int p = 0; p < numParts; ++p) {
                this.c_responseRecords[p] = new NamePlusRecord(berConstructed.elementAt(p), true);
            }
            return;
        }
        if (ber.getTag() == 130 && ber.getTagType() == 128) {
            this.c_nonSurrogateDiagnostic = new DefaultDiagFormat(ber, false);
            return;
        }
        if (ber.getTag() == 205 && ber.getTagType() == 128) {
            BERConstructed berConstructed;
            BEREncoding ber_data = ber;
            try {
                berConstructed = (BERConstructed)ber_data;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Records: bad BER form\n");
            }
            int numParts = berConstructed.numberComponents();
            this.c_multipleNonSurDiagnostics = new DiagRec[numParts];
            for (int p = 0; p < numParts; ++p) {
                this.c_multipleNonSurDiagnostics[p] = new DiagRec(berConstructed.elementAt(p), true);
            }
            return;
        }
        throw new ASN1Exception("Records: bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        int p;
        BEREncoding[] f2;
        BEREncoding chosen = null;
        if (this.c_responseRecords != null) {
            f2 = new BEREncoding[this.c_responseRecords.length];
            for (p = 0; p < this.c_responseRecords.length; ++p) {
                f2[p] = this.c_responseRecords[p].berEncode();
            }
            chosen = new BERConstructed(128, 28, f2);
        }
        if (this.c_nonSurrogateDiagnostic != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_nonSurrogateDiagnostic.berEncode(128, 130);
        }
        if (this.c_multipleNonSurDiagnostics != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            f2 = new BEREncoding[this.c_multipleNonSurDiagnostics.length];
            for (p = 0; p < this.c_multipleNonSurDiagnostics.length; ++p) {
                f2[p] = this.c_multipleNonSurDiagnostics[p].berEncode();
            }
            chosen = new BERConstructed(128, 205, f2);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("Records: cannot implicitly tag");
    }

    public String toString() {
        int p;
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_responseRecords != null) {
            found = true;
            str.append("responseRecords ");
            str.append("{");
            for (p = 0; p < this.c_responseRecords.length; ++p) {
                str.append((Object)this.c_responseRecords[p]);
            }
            str.append("}");
        }
        if (this.c_nonSurrogateDiagnostic != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: nonSurrogateDiagnostic> ");
            }
            found = true;
            str.append("nonSurrogateDiagnostic ");
            str.append((Object)this.c_nonSurrogateDiagnostic);
        }
        if (this.c_multipleNonSurDiagnostics != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: multipleNonSurDiagnostics> ");
            }
            str.append("multipleNonSurDiagnostics ");
            str.append("{");
            for (p = 0; p < this.c_multipleNonSurDiagnostics.length; ++p) {
                str.append((Object)this.c_multipleNonSurDiagnostics[p]);
            }
            str.append("}");
        }
        str.append("}");
        return str.toString();
    }
}

