/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Boolean;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;

public final class ResourceControlResponse
extends ASN1Any {
    public ReferenceId s_referenceId;
    public ASN1Boolean s_continueFlag;
    public ASN1Boolean s_resultSetWanted;
    public OtherInformation s_otherInfo;

    public ResourceControlResponse() {
    }

    public ResourceControlResponse(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.s_referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 44 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in continueFlag");
        }
        this.s_continueFlag = new ASN1Boolean(p, false);
        this.s_resultSetWanted = null;
        this.s_otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 45 && p.getTagType() == 128) {
            this.s_resultSetWanted = new ASN1Boolean(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.s_referenceId != null) {
            ++numFields;
        }
        if (this.s_resultSetWanted != null) {
            ++numFields;
        }
        if (this.s_otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_referenceId != null) {
            fields[x++] = this.s_referenceId.berEncode();
        }
        fields[x++] = this.s_continueFlag.berEncode(128, 44);
        if (this.s_resultSetWanted != null) {
            fields[x++] = this.s_resultSetWanted.berEncode(128, 45);
        }
        if (this.s_otherInfo != null) {
            fields[x] = this.s_otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.s_referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("continueFlag ");
        str.append(this.s_continueFlag);
        ++outputted;
        if (this.s_resultSetWanted != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("resultSetWanted ");
            str.append(this.s_resultSetWanted);
            ++outputted;
        }
        if (this.s_otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.s_otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

