/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;
import org.xbib.z3950.common.v3.ResourceReport;

public final class ResourceReportResponse
extends ASN1Any {
    public static final int E_success = 0;
    public static final int E_partial = 1;
    public static final int E_failure_1 = 2;
    public static final int E_failure_2 = 3;
    public static final int E_failure_3 = 4;
    public static final int E_failure_4 = 5;
    public static final int E_failure_5 = 6;
    public static final int E_failure_6 = 7;
    public ReferenceId s_referenceId;
    public ASN1Integer s_resourceReportStatus;
    public ResourceReport s_resourceReport;
    public OtherInformation s_otherInfo;

    public ResourceReportResponse() {
    }

    public ResourceReportResponse(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("ResourceReportResponse: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("ResourceReportResponse: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.s_referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("ResourceReportResponse: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 50 || p.getTagType() != 128) {
            throw new ASN1EncodingException("ResourceReportResponse: bad tag in s_resourceReportStatus\n");
        }
        this.s_resourceReportStatus = new ASN1Integer(p, false);
        this.s_resourceReport = null;
        this.s_otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 51 && p.getTagType() == 128) {
            BERConstructed tagged;
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("ResourceReportResponse: bad BER encoding: s_resourceReport tag bad\n");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("ResourceReportResponse: bad BER encoding: s_resourceReport tag bad\n");
            }
            this.s_resourceReport = new ResourceReport(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("ResourceReportResponse: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.s_referenceId != null) {
            ++numFields;
        }
        if (this.s_resourceReport != null) {
            ++numFields;
        }
        if (this.s_otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_referenceId != null) {
            fields[x++] = this.s_referenceId.berEncode();
        }
        fields[x++] = this.s_resourceReportStatus.berEncode(128, 50);
        if (this.s_resourceReport != null) {
            BEREncoding[] enc = new BEREncoding[]{this.s_resourceReport.berEncode()};
            fields[x++] = new BERConstructed(128, 51, enc);
        }
        if (this.s_otherInfo != null) {
            fields[x] = this.s_otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.s_referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("resourceReportStatus ");
        str.append(this.s_resourceReportStatus);
        ++outputted;
        if (this.s_resourceReport != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("resourceReport ");
            str.append((Object)this.s_resourceReport);
            ++outputted;
        }
        if (this.s_otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.s_otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

