/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.NamePlusRecord;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;

public final class Segment
extends ASN1Any {
    public ReferenceId s_referenceId;
    public ASN1Integer s_numberOfRecordsReturned;
    public NamePlusRecord[] s_segmentRecords;
    public OtherInformation s_otherInfo;

    public Segment(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("Segment: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("Segment: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.s_referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("Segment: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 24 || p.getTagType() != 128) {
            throw new ASN1EncodingException("Segment: bad tag in s_numberOfRecordsReturned\n");
        }
        this.s_numberOfRecordsReturned = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("Segment: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 0 || p.getTagType() != 128) {
            throw new ASN1EncodingException("Segment: bad tag in s_segmentRecords\n");
        }
        try {
            BERConstructed cons = (BERConstructed)p;
            int parts = cons.numberComponents();
            this.s_segmentRecords = new NamePlusRecord[parts];
            for (int n = 0; n < parts; ++n) {
                this.s_segmentRecords[n] = new NamePlusRecord(cons.elementAt(n), true);
            }
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("Bad BER");
        }
        this.s_otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("Segment: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 2;
        if (this.s_referenceId != null) {
            ++numFields;
        }
        if (this.s_otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_referenceId != null) {
            fields[x++] = this.s_referenceId.berEncode();
        }
        fields[x++] = this.s_numberOfRecordsReturned.berEncode(128, 24);
        BEREncoding[] f2 = new BEREncoding[this.s_segmentRecords.length];
        for (int p = 0; p < this.s_segmentRecords.length; ++p) {
            f2[p] = this.s_segmentRecords[p].berEncode();
        }
        fields[x++] = new BERConstructed(128, 0, f2);
        if (this.s_otherInfo != null) {
            fields[x] = this.s_otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.s_referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("numberOfRecordsReturned ");
        str.append(this.s_numberOfRecordsReturned);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("segmentRecords ");
        str.append("{");
        for (int p = 0; p < this.s_segmentRecords.length; ++p) {
            if (p != 0) {
                str.append(", ");
            }
            str.append((Object)this.s_segmentRecords[p]);
        }
        str.append("}");
        ++outputted;
        if (this.s_otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.s_otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

