/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Null;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.asn1.BEREncoding;

public final class SortKeySpecMissingValueAction
extends ASN1Any {
    public ASN1Null c_abort;
    public ASN1Null c_null;
    public ASN1OctetString c_missingValueData;

    public SortKeySpecMissingValueAction(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_abort = null;
        this.c_null = null;
        this.c_missingValueData = null;
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            this.c_abort = new ASN1Null(ber, false);
            return;
        }
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            this.c_null = new ASN1Null(ber, false);
            return;
        }
        if (ber.getTag() == 3 && ber.getTagType() == 128) {
            this.c_missingValueData = new ASN1OctetString(ber, false);
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.c_abort != null) {
            chosen = this.c_abort.berEncode(128, 1);
        }
        if (this.c_null != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_null.berEncode(128, 2);
        }
        if (this.c_missingValueData != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_missingValueData.berEncode(128, 3);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("SortKeySpec_missingValueAction: cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_abort != null) {
            found = true;
            str.append("abort ");
            str.append(this.c_abort);
        }
        if (this.c_null != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: null> ");
            }
            found = true;
            str.append("null ");
            str.append(this.c_null);
        }
        if (this.c_missingValueData != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: missingValueData> ");
            }
            str.append("missingValueData ");
            str.append(this.c_missingValueData);
        }
        str.append("}");
        return str.toString();
    }
}

