/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;
import org.xbib.z3950.common.v3.SortKeySpec;

public final class SortRequest
extends ASN1Any {
    public ReferenceId s_referenceId;
    public InternationalString[] s_inputResultSetNames;
    public InternationalString s_sortedResultSetName;
    public SortKeySpec[] s_sortSequence;
    public OtherInformation s_otherInfo;

    public SortRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        int n;
        int parts;
        BERConstructed cons;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("SortRequest: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.s_referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 3 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_inputResultSetNames");
        }
        try {
            cons = (BERConstructed)p;
            parts = cons.numberComponents();
            this.s_inputResultSetNames = new InternationalString[parts];
            for (n = 0; n < parts; ++n) {
                this.s_inputResultSetNames[n] = new InternationalString(cons.elementAt(n), true);
            }
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER");
        }
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 4 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in sortedResultSetName\n");
        }
        this.s_sortedResultSetName = new InternationalString(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 5 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in sortSequence\n");
        }
        try {
            cons = (BERConstructed)p;
            parts = cons.numberComponents();
            this.s_sortSequence = new SortKeySpec[parts];
            for (n = 0; n < parts; ++n) {
                this.s_sortSequence[n] = new SortKeySpec(cons.elementAt(n), true);
            }
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER");
        }
        this.s_otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int p;
        int numFields = 3;
        if (this.s_referenceId != null) {
            ++numFields;
        }
        if (this.s_otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_referenceId != null) {
            fields[x++] = this.s_referenceId.berEncode();
        }
        BEREncoding[] f2 = new BEREncoding[this.s_inputResultSetNames.length];
        for (p = 0; p < this.s_inputResultSetNames.length; ++p) {
            f2[p] = this.s_inputResultSetNames[p].berEncode();
        }
        fields[x++] = new BERConstructed(128, 3, f2);
        fields[x++] = this.s_sortedResultSetName.berEncode(128, 4);
        f2 = new BEREncoding[this.s_sortSequence.length];
        for (p = 0; p < this.s_sortSequence.length; ++p) {
            f2[p] = this.s_sortSequence[p].berEncode();
        }
        fields[x++] = new BERConstructed(128, 5, f2);
        if (this.s_otherInfo != null) {
            fields[x] = this.s_otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        int p;
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.s_referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("inputResultSetNames ");
        str.append("{");
        for (p = 0; p < this.s_inputResultSetNames.length; ++p) {
            if (p != 0) {
                str.append(", ");
            }
            str.append((Object)this.s_inputResultSetNames[p]);
        }
        str.append("}");
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("sortedResultSetName ");
        str.append((Object)this.s_sortedResultSetName);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("sortSequence ");
        str.append("{");
        for (p = 0; p < this.s_sortSequence.length; ++p) {
            if (p != 0) {
                str.append(", ");
            }
            str.append((Object)this.s_sortSequence[p]);
        }
        str.append("}");
        ++outputted;
        if (this.s_otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.s_otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

