/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DiagRec;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;

public final class SortResponse
extends ASN1Any {
    public static final int E_success = 0;
    public static final int E_partial_1 = 1;
    public static final int E_failure = 2;
    public static final int E_empty = 1;
    public static final int E_interim = 2;
    public static final int E_unchanged = 3;
    public static final int E_none = 4;
    public ReferenceId s_referenceId;
    public ASN1Integer s_sortStatus;
    public ASN1Integer s_resultSetStatus;
    public DiagRec[] s_diagnostics;
    public OtherInformation s_otherInfo;

    public SortResponse(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception(" incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.s_referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 3 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in sortStatus");
        }
        this.s_sortStatus = new ASN1Integer(p, false);
        this.s_resultSetStatus = null;
        this.s_diagnostics = null;
        this.s_otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 4 && p.getTagType() == 128) {
            this.s_resultSetStatus = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 5 && p.getTagType() == 128) {
            try {
                BERConstructed cons = (BERConstructed)p;
                int parts = cons.numberComponents();
                this.s_diagnostics = new DiagRec[parts];
                for (int n = 0; n < parts; ++n) {
                    this.s_diagnostics[n] = new DiagRec(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER");
            }
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("SortResponse: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.s_referenceId != null) {
            ++numFields;
        }
        if (this.s_resultSetStatus != null) {
            ++numFields;
        }
        if (this.s_diagnostics != null) {
            ++numFields;
        }
        if (this.s_otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_referenceId != null) {
            fields[x++] = this.s_referenceId.berEncode();
        }
        fields[x++] = this.s_sortStatus.berEncode(128, 3);
        if (this.s_resultSetStatus != null) {
            fields[x++] = this.s_resultSetStatus.berEncode(128, 4);
        }
        if (this.s_diagnostics != null) {
            BEREncoding[] f2 = new BEREncoding[this.s_diagnostics.length];
            for (int p = 0; p < this.s_diagnostics.length; ++p) {
                f2[p] = this.s_diagnostics[p].berEncode();
            }
            fields[x++] = new BERConstructed(128, 5, f2);
        }
        if (this.s_otherInfo != null) {
            fields[x] = this.s_otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.s_referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("sortStatus ");
        str.append(this.s_sortStatus);
        ++outputted;
        if (this.s_resultSetStatus != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("resultSetStatus ");
            str.append(this.s_resultSetStatus);
            ++outputted;
        }
        if (this.s_diagnostics != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("diagnostics ");
            str.append("{");
            for (int p = 0; p < this.s_diagnostics.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append((Object)this.s_diagnostics[p]);
            }
            str.append("}");
            ++outputted;
        }
        if (this.s_otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.s_otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

