/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.InternationalString;

public final class SpecificationElementSpec
extends ASN1Any {
    public InternationalString c_elementSetName;
    public ASN1External c_externalEspec;

    public SpecificationElementSpec(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_elementSetName = null;
        this.c_externalEspec = null;
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            this.c_elementSetName = new InternationalString(ber, false);
            return;
        }
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            this.c_externalEspec = new ASN1External(ber, false);
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.c_elementSetName != null) {
            chosen = this.c_elementSetName.berEncode(128, 1);
        }
        if (this.c_externalEspec != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_externalEspec.berEncode(128, 2);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_elementSetName != null) {
            found = true;
            str.append("elementSetName ");
            str.append((Object)this.c_elementSetName);
        }
        if (this.c_externalEspec != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: externalEspec> ");
            }
            str.append("externalEspec ");
            str.append(this.c_externalEspec);
        }
        str.append("}");
        return str.toString();
    }
}

