/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.InternationalString;

public final class StringOrNumeric
extends ASN1Any {
    public InternationalString c_string;
    public ASN1Integer c_numeric;

    public StringOrNumeric(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_string = null;
        this.c_numeric = null;
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            this.c_string = new InternationalString(ber, false);
            return;
        }
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            this.c_numeric = new ASN1Integer(ber, false);
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.c_string != null) {
            chosen = this.c_string.berEncode(128, 1);
        }
        if (this.c_numeric != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_numeric.berEncode(128, 2);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("StringOrNumeric: cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_string != null) {
            found = true;
            str.append("string ");
            str.append((Object)this.c_string);
        }
        if (this.c_numeric != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: numeric> ");
            }
            found = true;
            str.append("numeric ");
            str.append(this.c_numeric);
        }
        str.append("}");
        return str.toString();
    }
}

