/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AttributeList;
import org.xbib.z3950.common.v3.AttributesPlusTerm;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.OccurrenceByAttributes;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.Term;

public final class TermInfo
extends ASN1Any {
    public Term s_term;
    public InternationalString s_displayTerm;
    public AttributeList s_suggestedAttributes;
    public AttributesPlusTerm[] s_alternativeTerm;
    public ASN1Integer s_globalOccurrences;
    public OccurrenceByAttributes s_byAttributes;
    public OtherInformation s_otherTermInfo;

    public TermInfo() {
    }

    public TermInfo(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("TermInfo: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("TermInfo: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        this.s_term = new Term(p, true);
        ++part;
        this.s_displayTerm = null;
        this.s_suggestedAttributes = null;
        this.s_alternativeTerm = null;
        this.s_globalOccurrences = null;
        this.s_byAttributes = null;
        this.s_otherTermInfo = null;
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 0 && p.getTagType() == 128) {
            this.s_displayTerm = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_suggestedAttributes = new AttributeList(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_suggestedAttributes = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 4 && p.getTagType() == 128) {
            try {
                BERConstructed cons = (BERConstructed)p;
                int parts = cons.numberComponents();
                this.s_alternativeTerm = new AttributesPlusTerm[parts];
                for (int n = 0; n < parts; ++n) {
                    this.s_alternativeTerm[n] = new AttributesPlusTerm(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 2 && p.getTagType() == 128) {
            this.s_globalOccurrences = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 3 && p.getTagType() == 128) {
            this.s_byAttributes = new OccurrenceByAttributes(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherTermInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherTermInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("TermInfo: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.s_displayTerm != null) {
            ++numFields;
        }
        if (this.s_suggestedAttributes != null) {
            ++numFields;
        }
        if (this.s_alternativeTerm != null) {
            ++numFields;
        }
        if (this.s_globalOccurrences != null) {
            ++numFields;
        }
        if (this.s_byAttributes != null) {
            ++numFields;
        }
        if (this.s_otherTermInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        fields[x++] = this.s_term.berEncode();
        if (this.s_displayTerm != null) {
            fields[x++] = this.s_displayTerm.berEncode(128, 0);
        }
        if (this.s_suggestedAttributes != null) {
            fields[x++] = this.s_suggestedAttributes.berEncode();
        }
        if (this.s_alternativeTerm != null) {
            BEREncoding[] f2 = new BEREncoding[this.s_alternativeTerm.length];
            for (int p = 0; p < this.s_alternativeTerm.length; ++p) {
                f2[p] = this.s_alternativeTerm[p].berEncode();
            }
            fields[x++] = new BERConstructed(128, 4, f2);
        }
        if (this.s_globalOccurrences != null) {
            fields[x++] = this.s_globalOccurrences.berEncode(128, 2);
        }
        if (this.s_byAttributes != null) {
            fields[x++] = this.s_byAttributes.berEncode(128, 3);
        }
        if (this.s_otherTermInfo != null) {
            fields[x] = this.s_otherTermInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("term ");
        str.append((Object)this.s_term);
        ++outputted;
        if (this.s_displayTerm != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("displayTerm ");
            str.append((Object)this.s_displayTerm);
            ++outputted;
        }
        if (this.s_suggestedAttributes != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("suggestedAttributes ");
            str.append((Object)this.s_suggestedAttributes);
            ++outputted;
        }
        if (this.s_alternativeTerm != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("alternativeTerm ");
            str.append("{");
            for (int p = 0; p < this.s_alternativeTerm.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append((Object)this.s_alternativeTerm[p]);
            }
            str.append("}");
            ++outputted;
        }
        if (this.s_globalOccurrences != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("globalOccurrences ");
            str.append(this.s_globalOccurrences);
            ++outputted;
        }
        if (this.s_byAttributes != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("byAttributes ");
            str.append((Object)this.s_byAttributes);
            ++outputted;
        }
        if (this.s_otherTermInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherTermInfo ");
            str.append((Object)this.s_otherTermInfo);
        }
        str.append("}");
        return str.toString();
    }
}

