/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.StringOrNumeric;

public final class Unit
extends ASN1Any {
    public InternationalString s_unitSystem;
    public StringOrNumeric s_unitType;
    public StringOrNumeric s_unit;
    public ASN1Integer s_scaleFactor;

    public Unit(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed tagged;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("Unit: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        this.s_unitSystem = null;
        this.s_unitType = null;
        this.s_unit = null;
        this.s_scaleFactor = null;
        if (numParts <= part) {
            return;
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: s_unitSystem tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: s_unitSystem tag bad");
            }
            this.s_unitSystem = new InternationalString(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 2 && p.getTagType() == 128) {
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: s_unitType tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: s_unitType tag bad");
            }
            this.s_unitType = new StringOrNumeric(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 3 && p.getTagType() == 128) {
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: s_unit tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: s_unit tag bad");
            }
            this.s_unit = new StringOrNumeric(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 4 && p.getTagType() == 128) {
            this.s_scaleFactor = new ASN1Integer(p, false);
            ++part;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        BEREncoding[] enc;
        int numFields = 0;
        if (this.s_unitSystem != null) {
            ++numFields;
        }
        if (this.s_unitType != null) {
            ++numFields;
        }
        if (this.s_unit != null) {
            ++numFields;
        }
        if (this.s_scaleFactor != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_unitSystem != null) {
            enc = new BEREncoding[]{this.s_unitSystem.berEncode()};
            fields[x++] = new BERConstructed(128, 1, enc);
        }
        if (this.s_unitType != null) {
            enc = new BEREncoding[]{this.s_unitType.berEncode()};
            fields[x++] = new BERConstructed(128, 2, enc);
        }
        if (this.s_unit != null) {
            enc = new BEREncoding[]{this.s_unit.berEncode()};
            fields[x++] = new BERConstructed(128, 3, enc);
        }
        if (this.s_scaleFactor != null) {
            fields[x] = this.s_scaleFactor.berEncode(128, 4);
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_unitSystem != null) {
            str.append("unitSystem ");
            str.append((Object)this.s_unitSystem);
            ++outputted;
        }
        if (this.s_unitType != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("unitType ");
            str.append((Object)this.s_unitType);
            ++outputted;
        }
        if (this.s_unit != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("unit ");
            str.append((Object)this.s_unit);
            ++outputted;
        }
        if (this.s_scaleFactor != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("scaleFactor ");
            str.append(this.s_scaleFactor);
        }
        str.append("}");
        return str.toString();
    }
}

