/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.operations;

import java.io.IOException;
import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.io.BERReader;
import org.xbib.asn1.io.BERWriter;
import org.xbib.z3950.common.v3.Close;
import org.xbib.z3950.common.v3.InitializeRequest;
import org.xbib.z3950.common.v3.InitializeResponse;
import org.xbib.z3950.common.v3.PresentRequest;
import org.xbib.z3950.common.v3.PresentResponse;
import org.xbib.z3950.common.v3.ScanRequest;
import org.xbib.z3950.common.v3.ScanResponse;
import org.xbib.z3950.common.v3.SearchRequest;
import org.xbib.z3950.common.v3.SearchResponse;

public class AbstractOperation<IN extends ASN1Any, OUT extends ASN1Any> {
    protected final BERReader reader;
    protected final BERWriter writer;

    AbstractOperation(BERReader reader, BERWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    protected void write(OUT protocolDataUnit) throws IOException {
        try {
            this.writer.write(this.encode(protocolDataUnit));
        }
        catch (ASN1Exception ex) {
            throw new IOException(ex);
        }
    }

    protected IN read() throws IOException {
        try {
            BEREncoding ber = this.reader.read();
            if (ber == null) {
                throw new IOException("read PDU error");
            }
            return this.decode(ber);
        }
        catch (ASN1Exception ex) {
            throw new IOException(ex);
        }
        catch (NullPointerException ex) {
            throw new IOException("connection read PDU error", ex);
        }
    }

    private BEREncoding encode(OUT data) throws ASN1Exception {
        if (data instanceof InitializeRequest) {
            return data.berEncode(128, 20);
        }
        if (data instanceof InitializeResponse) {
            return data.berEncode(128, 21);
        }
        if (data instanceof SearchRequest) {
            return data.berEncode(128, 22);
        }
        if (data instanceof SearchResponse) {
            return data.berEncode(128, 23);
        }
        if (data instanceof PresentRequest) {
            return data.berEncode(128, 24);
        }
        if (data instanceof PresentResponse) {
            return data.berEncode(128, 25);
        }
        if (data instanceof ScanRequest) {
            return data.berEncode(128, 35);
        }
        if (data instanceof ScanResponse) {
            return data.berEncode(128, 36);
        }
        if (data instanceof Close) {
            return data.berEncode(128, 48);
        }
        throw new ASN1Exception("bad PDU to write");
    }

    private IN decode(BEREncoding ber) throws ASN1Exception {
        if (ber.getTagType() != 128) {
            throw new ASN1Exception("bad BER encoding: choice not matched");
        }
        switch (ber.getTag()) {
            case 20: {
                return (IN)((Object)new InitializeRequest(ber, false));
            }
            case 21: {
                return (IN)((Object)new InitializeResponse(ber, false));
            }
            case 22: {
                return (IN)((Object)new SearchRequest(ber, false));
            }
            case 23: {
                return (IN)((Object)new SearchResponse(ber, false));
            }
            case 24: {
                return (IN)((Object)new PresentRequest(ber, false));
            }
            case 25: {
                return (IN)((Object)new PresentResponse(ber, false));
            }
            case 35: {
                return (IN)((Object)new ScanRequest(ber, false));
            }
            case 36: {
                return (IN)((Object)new ScanResponse(ber, false));
            }
            case 48: {
                return (IN)((Object)new Close(ber, false));
            }
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }
}

