/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.operations;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.asn1.ASN1BitString;
import org.xbib.asn1.ASN1GeneralString;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.io.BERReader;
import org.xbib.asn1.io.BERWriter;
import org.xbib.z3950.api.InitListener;
import org.xbib.z3950.common.operations.AbstractOperation;
import org.xbib.z3950.common.v3.IdAuthentication;
import org.xbib.z3950.common.v3.IdAuthenticationIdPass;
import org.xbib.z3950.common.v3.InitializeRequest;
import org.xbib.z3950.common.v3.InitializeResponse;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.Options;
import org.xbib.z3950.common.v3.ProtocolVersion;

public class InitOperation
extends AbstractOperation<InitializeResponse, InitializeRequest> {
    private static final Logger logger = Logger.getLogger(InitOperation.class.getName());
    private final String user;
    private final String pass;
    private String targetInfo;

    public InitOperation(BERReader reader, BERWriter writer, String user, String pass) {
        super(reader, writer);
        this.user = user;
        this.pass = pass;
    }

    public boolean execute(Integer preferredMessageSize, InitListener initListener) throws IOException {
        InitializeRequest init = new InitializeRequest();
        boolean[] version = new boolean[]{true, true, true};
        init.protocolVersion = new ProtocolVersion();
        init.protocolVersion.value = new ASN1BitString(version);
        boolean[] options = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, false, false, false, true};
        init.options = new Options();
        init.options.value = new ASN1BitString(options);
        init.preferredMessageSize = new ASN1Integer(preferredMessageSize.intValue());
        init.exceptionalRecordSize = new ASN1Integer(preferredMessageSize * 2);
        init.implementationId = new InternationalString();
        init.implementationId.value = new ASN1GeneralString("1");
        init.implementationName = new InternationalString();
        init.implementationName.value = new ASN1GeneralString("Java ZClient");
        init.implementationVersion = new InternationalString();
        init.implementationVersion.value = new ASN1GeneralString("1.00");
        if (this.user != null) {
            init.idAuthentication = new IdAuthentication();
            init.idAuthentication.idPass = new IdAuthenticationIdPass();
            init.idAuthentication.idPass.s_userId = new InternationalString();
            init.idAuthentication.idPass.s_userId.value = new ASN1GeneralString(this.user);
            if (this.pass != null) {
                init.idAuthentication.idPass.s_password = new InternationalString();
                init.idAuthentication.idPass.s_password.value = new ASN1GeneralString(this.pass);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, init.toString());
        }
        this.write(init);
        InitializeResponse initResp = (InitializeResponse)((Object)this.read());
        if (initResp.implementationName != null) {
            this.targetInfo = initResp.implementationName.toString();
            if (initResp.implementationVersion != null) {
                this.targetInfo = this.targetInfo + " - " + initResp.implementationVersion.toString();
            }
        } else {
            this.targetInfo = "server";
        }
        int targetVersion = 0;
        if (initResp.protocolVersion != null) {
            for (int n = 0; n < initResp.protocolVersion.value.get().length; ++n) {
                if (!initResp.protocolVersion.value.get()[n]) continue;
                targetVersion = n + 1;
            }
            if (targetVersion > 0) {
                this.targetInfo = this.targetInfo + " (Version " + targetVersion + ")";
            }
        } else {
            this.targetInfo = this.targetInfo + " (Version unknown)";
        }
        if (initResp.userInformationField != null && initResp.userInformationField.getSingleASN1Type() != null) {
            this.targetInfo = this.targetInfo + "\n" + initResp.userInformationField.getSingleASN1Type().toString();
        }
        if (initResp.otherInfo != null) {
            this.targetInfo = this.targetInfo + "\n" + initResp.otherInfo.toString();
        }
        this.targetInfo = this.targetInfo.replaceAll("\"", "");
        if (initListener != null) {
            initListener.onInit(targetVersion, this.targetInfo);
        }
        return !initResp.result.get();
    }

    public String getTargetInfo() {
        return this.targetInfo;
    }
}

