/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.operations;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.ASN1GeneralString;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.io.BERReader;
import org.xbib.asn1.io.BERWriter;
import org.xbib.z3950.api.Record;
import org.xbib.z3950.api.RecordListener;
import org.xbib.z3950.api.SearchListener;
import org.xbib.z3950.common.DefaultRecord;
import org.xbib.z3950.common.ErrorRecord;
import org.xbib.z3950.common.exceptions.MessageSizeTooSmallException;
import org.xbib.z3950.common.exceptions.NoRecordsReturnedException;
import org.xbib.z3950.common.exceptions.RequestTerminatedByAccessControlException;
import org.xbib.z3950.common.exceptions.RequestTerminatedException;
import org.xbib.z3950.common.exceptions.ZException;
import org.xbib.z3950.common.operations.AbstractOperation;
import org.xbib.z3950.common.v3.DefaultDiagFormat;
import org.xbib.z3950.common.v3.ElementSetNames;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.NamePlusRecord;
import org.xbib.z3950.common.v3.PresentRequest;
import org.xbib.z3950.common.v3.PresentRequestRecordComposition;
import org.xbib.z3950.common.v3.PresentResponse;
import org.xbib.z3950.common.v3.ResultSetId;

public class PresentOperation
extends AbstractOperation<PresentResponse, PresentRequest> {
    private static final Logger logger = Logger.getLogger(PresentOperation.class.getName());
    private final String resultSetName;
    private final String elementSetName;
    private final String preferredRecordSyntax;

    public PresentOperation(BERReader reader, BERWriter writer, String resultSetName, String elementSetName, String preferredRecordSyntax) {
        super(reader, writer);
        this.resultSetName = resultSetName;
        this.elementSetName = elementSetName;
        this.preferredRecordSyntax = preferredRecordSyntax;
    }

    public void execute(int offset, int length, int total, SearchListener searchListener, RecordListener recordListener) throws IOException {
        int status;
        PresentRequest presentRequest = new PresentRequest();
        presentRequest.resultSetId = new ResultSetId();
        presentRequest.resultSetId.value = new InternationalString();
        presentRequest.resultSetId.value.value = new ASN1GeneralString(this.resultSetName);
        presentRequest.resultSetStartPoint = new ASN1Integer(offset);
        presentRequest.numberOfRecordsRequested = new ASN1Integer(length);
        presentRequest.recordComposition = new PresentRequestRecordComposition();
        presentRequest.recordComposition.simple = new ElementSetNames();
        presentRequest.recordComposition.simple.cGenericElementSetName = new InternationalString();
        presentRequest.recordComposition.simple.cGenericElementSetName.value = new ASN1GeneralString(this.elementSetName);
        presentRequest.preferredRecordSyntax = new ASN1ObjectIdentifier(this.makeOID(this.preferredRecordSyntax));
        long millis = System.currentTimeMillis();
        this.write(presentRequest);
        PresentResponse response = (PresentResponse)((Object)this.read());
        int nReturned = response.numberOfRecordsReturned != null ? response.numberOfRecordsReturned.get() : 0;
        int n = status = response.presentStatus.value != null ? response.presentStatus.value.get() : 0;
        if (searchListener != null) {
            searchListener.onResponse(status, total, nReturned, System.currentTimeMillis() - millis);
        }
        if (status == 0) {
            for (int n2 = 0; n2 < nReturned; ++n2) {
                DefaultRecord record;
                NamePlusRecord nr = response.records.c_responseRecords[n2];
                try {
                    ASN1External asn1External;
                    if (nr.record.retrievalRecord != null) {
                        ASN1External asn1External2 = new ASN1External(nr.record.retrievalRecord.berEncode(), true);
                        record = new DefaultRecord(offset + n2, asn1External2.getcOctetAligned().getBytes());
                        if (recordListener == null) continue;
                        recordListener.onRecord((Record)record);
                        continue;
                    }
                    if (nr.record.surrogateDiagnostic == null) continue;
                    DefaultDiagFormat diagFormat = nr.record.surrogateDiagnostic.defaultFormat;
                    if (diagFormat != null) {
                        logger.log(Level.WARNING, diagFormat.toString());
                    }
                    if ((asn1External = nr.record.surrogateDiagnostic.externallyDefined) == null) continue;
                    ErrorRecord record2 = new ErrorRecord(offset + n2, asn1External.getcOctetAligned().getBytes());
                    if (recordListener == null) continue;
                    recordListener.onRecord((Record)record2);
                    continue;
                }
                catch (ASN1Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                    if (recordListener == null) continue;
                    record = new ErrorRecord(offset + n2, e.getMessage().getBytes(StandardCharsets.UTF_8));
                    recordListener.onRecord((Record)record);
                }
            }
        } else {
            throw this.createZExceptionFrom(status, nReturned, response);
        }
    }

    private int[] makeOID(String str) throws NumberFormatException {
        String[] s = str.split("\\.");
        int[] a = new int[s.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = Integer.parseInt(s[i]);
        }
        return a;
    }

    private ZException createZExceptionFrom(int status, int nReturned, PresentResponse response) {
        switch (status) {
            case 1: {
                String message = "Some records were not returned (request was terminated by access control)";
                return new NoRecordsReturnedException(message, status);
            }
            case 2: {
                String message = "Some records were not returned (message size is too small)";
                return new MessageSizeTooSmallException(message, status, nReturned);
            }
            case 3: {
                String message = "Some records were not returned (request was terminated by control, at origin request)";
                return new RequestTerminatedByAccessControlException(message, status, nReturned);
            }
            case 4: {
                String message = "Some records were not returned (request was terminated by control, by the target)";
                return new RequestTerminatedException(message, status, nReturned);
            }
            case 5: {
                return new NoRecordsReturnedException(response.toString(), status);
            }
        }
        return new ZException(response.toString(), status, nReturned);
    }
}

