/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.operations;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Boolean;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1GeneralString;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1Sequence;
import org.xbib.asn1.io.BERReader;
import org.xbib.asn1.io.BERWriter;
import org.xbib.cql.CQLParser;
import org.xbib.cql.Visitor;
import org.xbib.z3950.common.Diagnostics;
import org.xbib.z3950.common.cql.CQLRPNGenerator;
import org.xbib.z3950.common.operations.AbstractOperation;
import org.xbib.z3950.common.pqf.PQFParser;
import org.xbib.z3950.common.pqf.PQFRPNGenerator;
import org.xbib.z3950.common.v3.DatabaseName;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.OtherInformation1;
import org.xbib.z3950.common.v3.PresentStatus;
import org.xbib.z3950.common.v3.Query;
import org.xbib.z3950.common.v3.RPNQuery;
import org.xbib.z3950.common.v3.SearchRequest;
import org.xbib.z3950.common.v3.SearchResponse;

public class SearchOperation
extends AbstractOperation<SearchResponse, SearchRequest> {
    private static final Logger logger = Logger.getLogger(SearchOperation.class.getName());
    private int count = -1;
    private boolean status = false;
    private final Map<ASN1Any, Integer> results;
    private final String resultSetName;
    private final List<String> databases;
    private final String host;

    public SearchOperation(BERReader reader, BERWriter writer, String resultSetName, List<String> databases, String host) {
        super(reader, writer);
        this.resultSetName = resultSetName;
        this.databases = databases;
        this.host = host;
        this.results = new HashMap<ASN1Any, Integer>();
    }

    public boolean executePQF(String pqf) throws IOException {
        return this.execute(this.createRPNQueryFromPQF(pqf));
    }

    public boolean executeCQL(String cql) throws IOException {
        return this.execute(this.createRPNQueryFromCQL(cql));
    }

    public boolean execute(RPNQuery rpn) throws IOException {
        try {
            SearchRequest search = new SearchRequest();
            search.query = new Query();
            search.query.c_type_1 = rpn;
            search.smallSetUpperBound = new ASN1Integer(0);
            search.largeSetLowerBound = new ASN1Integer(1);
            search.mediumSetPresentNumber = new ASN1Integer(0);
            search.replaceIndicator = new ASN1Boolean(true);
            search.resultSetName = new InternationalString();
            search.resultSetName.value = new ASN1GeneralString(this.resultSetName);
            DatabaseName[] dbs = new DatabaseName[this.databases.size()];
            for (int n = 0; n < this.databases.size(); ++n) {
                dbs[n] = new DatabaseName();
                dbs[n].value = new InternationalString();
                dbs[n].value.value = new ASN1GeneralString(this.databases.get(n));
            }
            search.databaseNames = dbs;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, search.toString());
            }
            this.write(search);
            SearchResponse response = (SearchResponse)((Object)this.read());
            if (response != null) {
                ASN1Boolean b;
                if (response.resultCount != null) {
                    this.count = response.resultCount.get();
                }
                boolean bl = this.status = (b = response.s_searchStatus) != null && b.get();
                if (!this.status) {
                    if (response.s_records != null && response.s_records.c_nonSurrogateDiagnostic != null) {
                        int code = response.s_records.c_nonSurrogateDiagnostic.condition.get();
                        String addInfo = response.s_records.c_nonSurrogateDiagnostic.addinfo.v2Addinfo.get();
                        throw new Diagnostics(code, addInfo);
                    }
                    throw new IOException(this.host + ": error, without diagnostic");
                }
                PresentStatus presentStatus = response.s_presentStatus;
                if (presentStatus != null && presentStatus.value != null && presentStatus.value.get() == 5) {
                    throw new IOException("present status is failure");
                }
                if (response.s_additionalSearchInfo != null && response.s_additionalSearchInfo.value[0] != null) {
                    OtherInformation1 info = response.s_additionalSearchInfo.value[0];
                    ASN1Sequence targetSeq = (ASN1Sequence)info.information.c_externallyDefinedInfo.getSingleASN1Type();
                    ASN1Any[] targets = targetSeq.get();
                    for (int i = 0; i < targets.length; ++i) {
                        ASN1Sequence target = (ASN1Sequence)targets[i];
                        try {
                            ASN1Any[] details = target.get();
                            DatabaseName dbName = new DatabaseName(details[0].berEncode(), false);
                            if (!dbName.value.value.get().equalsIgnoreCase(this.databases.get(i))) {
                                String message = "database name listed in additional search info doesn't match database name in names set";
                                throw new IOException(this.host + ": " + message);
                            }
                            ASN1Integer res = (ASN1Integer)details[1];
                            this.results.put((ASN1Any)target, res.get());
                            continue;
                        }
                        catch (ASN1Exception ex) {
                            logger.log(Level.WARNING, ex.getMessage(), ex);
                            this.results.put((ASN1Any)target, -1);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IOException(this.host + ": " + e.getMessage(), e);
        }
        return this.status;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isSuccess() {
        return this.status;
    }

    public Map<ASN1Any, Integer> getResults() {
        return this.results;
    }

    private RPNQuery createRPNQueryFromCQL(String query) {
        CQLRPNGenerator generator = new CQLRPNGenerator();
        CQLParser parser = new CQLParser(query);
        parser.parse();
        parser.getCQLQuery().accept((Visitor)generator);
        return generator.getQueryResult();
    }

    private RPNQuery createRPNQueryFromPQF(String query) {
        PQFRPNGenerator generator = new PQFRPNGenerator();
        PQFParser parser = new PQFParser(new StringReader(query));
        parser.parse();
        parser.getResult().accept(generator);
        return generator.getResult();
    }
}

