/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.pqf;

import java.util.Stack;
import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1Null;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.z3950.common.pqf.AttrStr;
import org.xbib.z3950.common.pqf.Expression;
import org.xbib.z3950.common.pqf.PQF;
import org.xbib.z3950.common.pqf.Query;
import org.xbib.z3950.common.pqf.Setname;
import org.xbib.z3950.common.pqf.SyntaxException;
import org.xbib.z3950.common.pqf.Term;
import org.xbib.z3950.common.pqf.Visitor;
import org.xbib.z3950.common.v3.AttributeElement;
import org.xbib.z3950.common.v3.AttributeElementAttributeValue;
import org.xbib.z3950.common.v3.AttributeList;
import org.xbib.z3950.common.v3.AttributeSetId;
import org.xbib.z3950.common.v3.AttributesPlusTerm;
import org.xbib.z3950.common.v3.Operand;
import org.xbib.z3950.common.v3.Operator;
import org.xbib.z3950.common.v3.RPNQuery;
import org.xbib.z3950.common.v3.RPNStructure;
import org.xbib.z3950.common.v3.RPNStructureRpnRpnOp;

public class PQFRPNGenerator
implements Visitor {
    private Stack<ASN1Any> result = new Stack();
    private RPNQuery rpnQuery;

    public RPNQuery getResult() {
        return this.rpnQuery;
    }

    @Override
    public void visit(PQF pqf) {
        if (!this.result.isEmpty()) {
            this.rpnQuery = new RPNQuery();
            this.rpnQuery.rpn = (RPNStructure)this.result.pop();
            if (pqf.getAttrSet() == null) {
                this.rpnQuery.attributeSetId = new AttributeSetId();
                this.rpnQuery.attributeSetId.value = new ASN1ObjectIdentifier(new int[]{1, 2, 840, 10003, 3, 1});
            }
        } else {
            throw new SyntaxException("no valid PQF found");
        }
    }

    @Override
    public void visit(Query query) {
        ASN1Any any;
        Operand operand = new Operand();
        operand.attrTerm = new AttributesPlusTerm();
        operand.attrTerm.term = new org.xbib.z3950.common.v3.Term();
        operand.attrTerm.term.c_general = new ASN1OctetString(query.getTerm().getValue());
        Stack<AttributeElement> attrs = new Stack<AttributeElement>();
        ASN1Any aSN1Any = any = !this.result.isEmpty() && this.result.peek() instanceof AttributeElement ? this.result.pop() : null;
        while (any != null) {
            attrs.push((AttributeElement)any);
            any = !this.result.isEmpty() && this.result.peek() instanceof AttributeElement ? this.result.pop() : null;
        }
        operand.attrTerm.attributes = new AttributeList();
        operand.attrTerm.attributes.value = attrs.toArray(new AttributeElement[attrs.size()]);
        RPNStructure rpn = new RPNStructure();
        rpn.c_op = operand;
        if (attrs.size() > 0) {
            this.result.push(rpn);
        }
    }

    @Override
    public void visit(Expression expr) {
        String op = expr.getOperator();
        RPNStructure rpn = new RPNStructure();
        rpn.c_rpnRpnOp = new RPNStructureRpnRpnOp();
        rpn.c_rpnRpnOp.s_op = new Operator();
        if ("@and".equals(op)) {
            rpn.c_rpnRpnOp.s_op.andOp = new ASN1Null();
        }
        if ("@or".equals(op)) {
            rpn.c_rpnRpnOp.s_op.orOp = new ASN1Null();
        }
        if ("@not".equals(op)) {
            rpn.c_rpnRpnOp.s_op.andNotOp = new ASN1Null();
        }
        rpn.c_rpnRpnOp.s_rpn1 = (RPNStructure)this.result.pop();
        rpn.c_rpnRpnOp.s_rpn2 = (RPNStructure)this.result.pop();
        this.result.push(rpn);
    }

    @Override
    public void visit(AttrStr attrspec) {
        AttributeElement ae = new AttributeElement();
        ae.attributeType = (ASN1Integer)this.result.pop();
        ae.attributeValue = new AttributeElementAttributeValue();
        ae.attributeValue.numeric = (ASN1Integer)this.result.pop();
        this.result.push(ae);
    }

    @Override
    public void visit(Term term) {
        this.result.push((ASN1Any)new ASN1OctetString(term.getValue()));
    }

    @Override
    public void visit(Setname name) {
        this.result.push((ASN1Any)new ASN1OctetString(name.getValue()));
    }

    @Override
    public void visit(Integer i) {
        this.result.push((ASN1Any)new ASN1Integer(i.intValue()));
    }

    @Override
    public void visit(String str) {
        this.result.push((ASN1Any)new ASN1OctetString(str));
    }
}

