/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AttributeElementAttributeValue;
import org.xbib.z3950.common.v3.AttributeSetId;

public final class AttributeElement
extends ASN1Any
implements Comparable<AttributeElement> {
    public AttributeSetId attributeSetId;
    public ASN1Integer attributeType;
    public AttributeElementAttributeValue attributeValue;

    public AttributeElement() {
    }

    public AttributeElement(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("AttributeElement: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("AttributeElement: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            this.attributeSetId = new AttributeSetId(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("AttributeElement: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 120 || p.getTagType() != 128) {
            throw new ASN1EncodingException("AttributeElement: bad tag in s_attributeType\n");
        }
        this.attributeType = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("AttributeElement: incomplete");
        }
        p = berConstructed.elementAt(part);
        this.attributeValue = new AttributeElementAttributeValue(p, true);
        if (++part < numParts) {
            throw new ASN1Exception("AttributeElement: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 2;
        if (this.attributeSetId != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.attributeSetId != null) {
            fields[x++] = this.attributeSetId.berEncode(128, 1);
        }
        fields[x++] = this.attributeType.berEncode(128, 120);
        fields[x] = this.attributeValue.berEncode();
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.attributeSetId != null) {
            str.append("attributeSet ");
            str.append((Object)this.attributeSetId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("attributeType ");
        str.append(this.attributeType);
        str.append(", ");
        str.append("attributeValue ");
        str.append((Object)this.attributeValue);
        str.append("}");
        return str.toString();
    }

    @Override
    public int compareTo(AttributeElement o) {
        return this.attributeType.toString().compareTo(o.attributeType.toString());
    }
}

