/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AttributeElementAttributeValueComplex;

public final class AttributeElementAttributeValue
extends ASN1Any {
    public ASN1Integer numeric;
    public AttributeElementAttributeValueComplex complex;

    public AttributeElementAttributeValue() {
    }

    public AttributeElementAttributeValue(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.numeric = null;
        this.complex = null;
        if (ber.getTag() == 121 && ber.getTagType() == 128) {
            this.numeric = new ASN1Integer(ber, false);
            return;
        }
        if (ber.getTag() == 224 && ber.getTagType() == 128) {
            this.complex = new AttributeElementAttributeValueComplex(ber, false);
            return;
        }
        throw new ASN1Exception("AttributeElement_attributeValue: bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.numeric != null) {
            chosen = this.numeric.berEncode(128, 121);
        }
        if (this.complex != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.complex.berEncode(128, 224);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("AttributeElement_attributeValue: cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.numeric != null) {
            found = true;
            str.append("numeric ");
            str.append(this.numeric);
        }
        if (this.complex != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: complex> ");
            }
            str.append("complex ");
            str.append((Object)this.complex);
        }
        str.append("}");
        return str.toString();
    }
}

