/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.CloseReason;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;
import org.xbib.z3950.common.v3.ResourceReport;
import org.xbib.z3950.common.v3.ResourceReportId;

public final class Close
extends ASN1Any {
    public ReferenceId referenceId;
    public CloseReason closeReason;
    public InternationalString diagnosticInformation;
    public ResourceReportId resourceReportFormat;
    public ResourceReport resourceReport;
    public OtherInformation otherInformation;

    public Close() {
    }

    public Close(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("Close: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("Close: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("Close: incomplete");
        }
        p = berConstructed.elementAt(part);
        this.closeReason = new CloseReason(p, true);
        this.diagnosticInformation = null;
        this.resourceReportFormat = null;
        this.resourceReport = null;
        this.otherInformation = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 3 && p.getTagType() == 128) {
            this.diagnosticInformation = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 4 && p.getTagType() == 128) {
            this.resourceReportFormat = new ResourceReportId(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 5 && p.getTagType() == 128) {
            BERConstructed tagged;
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Close: bad BER encoding: s_resourceReport tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("Close: bad BER encoding: s_resourceReport tag bad");
            }
            this.resourceReport = new ResourceReport(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.otherInformation = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.otherInformation = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("Close: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.diagnosticInformation != null) {
            ++numFields;
        }
        if (this.resourceReportFormat != null) {
            ++numFields;
        }
        if (this.resourceReport != null) {
            ++numFields;
        }
        if (this.otherInformation != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        fields[x++] = this.closeReason.berEncode();
        if (this.diagnosticInformation != null) {
            fields[x++] = this.diagnosticInformation.berEncode(128, 3);
        }
        if (this.resourceReportFormat != null) {
            fields[x++] = this.resourceReportFormat.berEncode(128, 4);
        }
        if (this.resourceReport != null) {
            BEREncoding[] enc = new BEREncoding[]{this.resourceReport.berEncode()};
            fields[x++] = new BERConstructed(128, 5, enc);
        }
        if (this.otherInformation != null) {
            fields[x] = this.otherInformation.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("closeReason ");
        str.append((Object)this.closeReason);
        ++outputted;
        if (this.diagnosticInformation != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("diagnosticInformation ");
            str.append((Object)this.diagnosticInformation);
            ++outputted;
        }
        if (this.resourceReportFormat != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("resourceReportFormat ");
            str.append((Object)this.resourceReportFormat);
            ++outputted;
        }
        if (this.resourceReport != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("resourceReport ");
            str.append((Object)this.resourceReport);
            ++outputted;
        }
        if (this.otherInformation != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.otherInformation);
        }
        str.append("}");
        return str.toString();
    }
}

