/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DatabaseName;
import org.xbib.z3950.common.v3.Specification;

public final class CompSpecDbSpecific
extends ASN1Any {
    public DatabaseName sDb;
    public Specification sSpec;

    public CompSpecDbSpecific(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed tagged;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("CompSpec_dbSpecific: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("CompSpec_dbSpecific: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() != 1 || p.getTagType() != 128) {
            throw new ASN1EncodingException("CompSpec_dbSpecific: bad tag in s_db\n");
        }
        try {
            tagged = (BERConstructed)p;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("CompSpec_dbSpecific: bad BER encoding: s_db tag bad\n");
        }
        if (tagged.numberComponents() != 1) {
            throw new ASN1EncodingException("CompSpec_dbSpecific: bad BER encoding: s_db tag bad\n");
        }
        this.sDb = new DatabaseName(tagged.elementAt(0), true);
        if (numParts <= ++part) {
            throw new ASN1Exception("CompSpec_dbSpecific: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 2 || p.getTagType() != 128) {
            throw new ASN1EncodingException("CompSpec_dbSpecific: bad tag in s_spec\n");
        }
        this.sSpec = new Specification(p, false);
        if (++part < numParts) {
            throw new ASN1Exception("CompSpec_dbSpecific: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 2;
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        BEREncoding[] enc = new BEREncoding[]{this.sDb.berEncode()};
        fields[x++] = new BERConstructed(128, 1, enc);
        fields[x] = this.sSpec.berEncode(128, 2);
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("db ");
        str.append((Object)this.sDb);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("spec ");
        str.append((Object)this.sSpec);
        str.append("}");
        return str.toString();
    }
}

