/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DeleteSetStatus;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.ListStatuses;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;

public final class DeleteResultSetResponse
extends ASN1Any {
    public ReferenceId sReferenceId;
    public DeleteSetStatus sDeleteOperationStatus;
    public ListStatuses sDeleteListStatuses;
    public ASN1Integer sNumberNotDeleted;
    public ListStatuses sBulkStatuses;
    public InternationalString sDeleteMessage;
    public OtherInformation sOtherInfo;

    public DeleteResultSetResponse(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("DeleteResultSetResponse: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("DeleteResultSetResponse: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.sReferenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sReferenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("DeleteResultSetResponse: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 0 || p.getTagType() != 128) {
            throw new ASN1EncodingException("DeleteResultSetResponse: bad tag in s_deleteOperationStatus\n");
        }
        this.sDeleteOperationStatus = new DeleteSetStatus(p, false);
        ++part;
        this.sDeleteListStatuses = null;
        this.sNumberNotDeleted = null;
        this.sBulkStatuses = null;
        this.sDeleteMessage = null;
        this.sOtherInfo = null;
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            this.sDeleteListStatuses = new ListStatuses(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 34 && p.getTagType() == 128) {
            this.sNumberNotDeleted = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 35 && p.getTagType() == 128) {
            this.sBulkStatuses = new ListStatuses(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 36 && p.getTagType() == 128) {
            this.sDeleteMessage = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.sOtherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sOtherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("DeleteResultSetResponse: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.sReferenceId != null) {
            ++numFields;
        }
        if (this.sDeleteListStatuses != null) {
            ++numFields;
        }
        if (this.sNumberNotDeleted != null) {
            ++numFields;
        }
        if (this.sBulkStatuses != null) {
            ++numFields;
        }
        if (this.sDeleteMessage != null) {
            ++numFields;
        }
        if (this.sOtherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.sReferenceId != null) {
            fields[x++] = this.sReferenceId.berEncode();
        }
        fields[x++] = this.sDeleteOperationStatus.berEncode(128, 0);
        if (this.sDeleteListStatuses != null) {
            fields[x++] = this.sDeleteListStatuses.berEncode(128, 1);
        }
        if (this.sNumberNotDeleted != null) {
            fields[x++] = this.sNumberNotDeleted.berEncode(128, 34);
        }
        if (this.sBulkStatuses != null) {
            fields[x++] = this.sBulkStatuses.berEncode(128, 35);
        }
        if (this.sDeleteMessage != null) {
            fields[x++] = this.sDeleteMessage.berEncode(128, 36);
        }
        if (this.sOtherInfo != null) {
            fields[x] = this.sOtherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.sReferenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.sReferenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("deleteOperationStatus ");
        str.append((Object)this.sDeleteOperationStatus);
        ++outputted;
        if (this.sDeleteListStatuses != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("deleteListStatuses ");
            str.append((Object)this.sDeleteListStatuses);
            ++outputted;
        }
        if (this.sNumberNotDeleted != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("numberNotDeleted ");
            str.append(this.sNumberNotDeleted);
            ++outputted;
        }
        if (this.sBulkStatuses != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("bulkStatuses ");
            str.append((Object)this.sBulkStatuses);
            ++outputted;
        }
        if (this.sDeleteMessage != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("deleteMessage ");
            str.append((Object)this.sDeleteMessage);
            ++outputted;
        }
        if (this.sOtherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.sOtherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

