/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DatabaseName;
import org.xbib.z3950.common.v3.ElementSetName;

public final class ElementSetNamesDatabaseSpecific
extends ASN1Any {
    public DatabaseName dbName;
    public ElementSetName elementSetName;

    public ElementSetNamesDatabaseSpecific() {
    }

    public ElementSetNamesDatabaseSpecific(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        this.dbName = new DatabaseName(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.elementSetName = new ElementSetName(p, true);
        if (++part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 2;
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        fields[x++] = this.dbName.berEncode();
        fields[x] = this.elementSetName.berEncode();
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("dbName ");
        str.append((Object)this.dbName);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("esn ");
        str.append((Object)this.elementSetName);
        str.append("}");
        return str.toString();
    }
}

