/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DiagRec;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;

public final class ExtendedServicesResponse
extends ASN1Any {
    public static final int E_DONE = 1;
    public static final int E_ACCEPTED = 2;
    public static final int E_FAILURE = 3;
    public ReferenceId sReferenceId;
    public ASN1Integer sOperationStatus;
    public DiagRec[] sDiagnostics;
    public ASN1External sTaskPackage;
    public OtherInformation sOtherInfo;

    public ExtendedServicesResponse(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.sReferenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sReferenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 3 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in operationStatus");
        }
        this.sOperationStatus = new ASN1Integer(p, false);
        this.sDiagnostics = null;
        this.sTaskPackage = null;
        this.sOtherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 4 && p.getTagType() == 128) {
            try {
                BERConstructed cons = (BERConstructed)p;
                int parts = cons.numberComponents();
                this.sDiagnostics = new DiagRec[parts];
                for (int n = 0; n < parts; ++n) {
                    this.sDiagnostics[n] = new DiagRec(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 5 && p.getTagType() == 128) {
            this.sTaskPackage = new ASN1External(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.sOtherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sOtherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.sReferenceId != null) {
            ++numFields;
        }
        if (this.sDiagnostics != null) {
            ++numFields;
        }
        if (this.sTaskPackage != null) {
            ++numFields;
        }
        if (this.sOtherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.sReferenceId != null) {
            fields[x++] = this.sReferenceId.berEncode();
        }
        fields[x++] = this.sOperationStatus.berEncode(128, 3);
        if (this.sDiagnostics != null) {
            BEREncoding[] f2 = new BEREncoding[this.sDiagnostics.length];
            for (int p = 0; p < this.sDiagnostics.length; ++p) {
                f2[p] = this.sDiagnostics[p].berEncode();
            }
            fields[x++] = new BERConstructed(128, 4, f2);
        }
        if (this.sTaskPackage != null) {
            fields[x++] = this.sTaskPackage.berEncode(128, 5);
        }
        if (this.sOtherInfo != null) {
            fields[x] = this.sOtherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.sReferenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.sReferenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("operationStatus ");
        str.append(this.sOperationStatus);
        ++outputted;
        if (this.sDiagnostics != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("diagnostics ");
            str.append("{");
            for (int p = 0; p < this.sDiagnostics.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append((Object)this.sDiagnostics[p]);
            }
            str.append("}");
            ++outputted;
        }
        if (this.sTaskPackage != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("taskPackage ");
            str.append(this.sTaskPackage);
            ++outputted;
        }
        if (this.sOtherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.sOtherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

