/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.ASN1Null;
import org.xbib.asn1.ASN1VisibleString;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.IdAuthenticationIdPass;

public final class IdAuthentication
extends ASN1Any {
    public ASN1VisibleString open;
    public IdAuthenticationIdPass idPass;
    public ASN1Null anonymous;
    public ASN1External other;

    public IdAuthentication() {
    }

    public IdAuthentication(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.open = null;
        this.idPass = null;
        this.anonymous = null;
        this.other = null;
        try {
            this.open = new ASN1VisibleString(ber, checkTag);
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            try {
                this.idPass = new IdAuthenticationIdPass(ber, checkTag);
                return;
            }
            catch (ASN1Exception aSN1Exception2) {
                try {
                    this.anonymous = new ASN1Null(ber, checkTag);
                    return;
                }
                catch (ASN1Exception aSN1Exception3) {
                    try {
                        this.other = new ASN1External(ber, checkTag);
                        return;
                    }
                    catch (ASN1Exception aSN1Exception4) {
                        throw new ASN1Exception("bad BER encoding: choice not matched");
                    }
                }
            }
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.open != null) {
            chosen = this.open.berEncode();
        }
        if (this.idPass != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.idPass.berEncode();
        }
        if (this.anonymous != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.anonymous.berEncode();
        }
        if (this.other != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.other.berEncode();
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.open != null) {
            found = true;
            str.append("open ");
            str.append(this.open);
        }
        if (this.idPass != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: idPass> ");
            }
            found = true;
            str.append("idPass ");
            str.append((Object)this.idPass);
        }
        if (this.anonymous != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: anonymous> ");
            }
            found = true;
            str.append("anonymous ");
            str.append(this.anonymous);
        }
        if (this.other != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: other> ");
            }
            str.append("other ");
            str.append(this.other);
        }
        str.append("}");
        return str.toString();
    }
}

