/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;

public final class InfoCategory
extends ASN1Any {
    public ASN1ObjectIdentifier s_categoryTypeId;
    public ASN1Integer s_categoryValue;

    public InfoCategory(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("InfoCategory: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("InfoCategory: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            this.s_categoryTypeId = new ASN1ObjectIdentifier(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("InfoCategory: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 2 || p.getTagType() != 128) {
            throw new ASN1EncodingException("InfoCategory: bad tag in s_categoryValue\n");
        }
        this.s_categoryValue = new ASN1Integer(p, false);
        if (++part < numParts) {
            throw new ASN1Exception("InfoCategory: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.s_categoryTypeId != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_categoryTypeId != null) {
            fields[x++] = this.s_categoryTypeId.berEncode(128, 1);
        }
        fields[x] = this.s_categoryValue.berEncode(128, 2);
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_categoryTypeId != null) {
            str.append("categoryTypeId ");
            str.append(this.s_categoryTypeId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("categoryValue ");
        str.append(this.s_categoryValue);
        str.append("}");
        return str.toString();
    }
}

