/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DiagRec;
import org.xbib.z3950.common.v3.Entry;

public final class ListEntries
extends ASN1Any {
    public Entry[] s_entries;
    public DiagRec[] s_nonsurrogateDiagnostics;

    public ListEntries(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        int n;
        int parts;
        BERConstructed cons;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        this.s_entries = null;
        this.s_nonsurrogateDiagnostics = null;
        if (numParts <= part) {
            return;
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            try {
                cons = (BERConstructed)p;
                parts = cons.numberComponents();
                this.s_entries = new Entry[parts];
                for (n = 0; n < parts; ++n) {
                    this.s_entries[n] = new Entry(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER");
            }
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 2 && p.getTagType() == 128) {
            try {
                cons = (BERConstructed)p;
                parts = cons.numberComponents();
                this.s_nonsurrogateDiagnostics = new DiagRec[parts];
                for (n = 0; n < parts; ++n) {
                    this.s_nonsurrogateDiagnostics[n] = new DiagRec(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER");
            }
            ++part;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int p;
        BEREncoding[] f2;
        int numFields = 0;
        if (this.s_entries != null) {
            ++numFields;
        }
        if (this.s_nonsurrogateDiagnostics != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_entries != null) {
            f2 = new BEREncoding[this.s_entries.length];
            for (p = 0; p < this.s_entries.length; ++p) {
                f2[p] = this.s_entries[p].berEncode();
            }
            fields[x++] = new BERConstructed(128, 1, f2);
        }
        if (this.s_nonsurrogateDiagnostics != null) {
            f2 = new BEREncoding[this.s_nonsurrogateDiagnostics.length];
            for (p = 0; p < this.s_nonsurrogateDiagnostics.length; ++p) {
                f2[p] = this.s_nonsurrogateDiagnostics[p].berEncode();
            }
            fields[x] = new BERConstructed(128, 2, f2);
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        int p;
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_entries != null) {
            str.append("entries ");
            str.append("{");
            for (p = 0; p < this.s_entries.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append((Object)this.s_entries[p]);
            }
            str.append("}");
            ++outputted;
        }
        if (this.s_nonsurrogateDiagnostics != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("nonsurrogateDiagnostics ");
            str.append("{");
            for (p = 0; p < this.s_nonsurrogateDiagnostics.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append((Object)this.s_nonsurrogateDiagnostics[p]);
            }
            str.append("}");
        }
        str.append("}");
        return str.toString();
    }
}

