/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DatabaseName;
import org.xbib.z3950.common.v3.NamePlusRecordRecord;

public final class NamePlusRecord
extends ASN1Any {
    public DatabaseName name;
    public NamePlusRecordRecord record;

    public NamePlusRecord() {
    }

    public NamePlusRecord(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed tagged;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() == 0 && p.getTagType() == 128) {
            this.name = new DatabaseName(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 1 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in record");
        }
        try {
            tagged = (BERConstructed)p;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER encoding: record tag bad");
        }
        if (tagged.numberComponents() != 1) {
            throw new ASN1EncodingException("bad BER encoding: record tag bad");
        }
        this.record = new NamePlusRecordRecord(tagged.elementAt(0), true);
        if (++part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.name != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.name != null) {
            fields[x++] = this.name.berEncode(128, 0);
        }
        BEREncoding[] enc = new BEREncoding[]{this.record.berEncode()};
        fields[x] = new BERConstructed(128, 1, enc);
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.name != null) {
            str.append("name ");
            str.append((Object)this.name);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("record ");
        str.append((Object)this.record);
        str.append("}");
        return str.toString();
    }
}

