/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DiagRec;
import org.xbib.z3950.common.v3.FragmentSyntax;

public final class NamePlusRecordRecord
extends ASN1Any {
    public ASN1External retrievalRecord;
    public DiagRec surrogateDiagnostic;
    public FragmentSyntax startingFragment;
    public FragmentSyntax intermediateFragment;
    public FragmentSyntax finalFragment;

    public NamePlusRecordRecord(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.retrievalRecord = null;
        this.surrogateDiagnostic = null;
        this.startingFragment = null;
        this.intermediateFragment = null;
        this.finalFragment = null;
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER form");
            }
            this.retrievalRecord = new ASN1External(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER form");
            }
            this.surrogateDiagnostic = new DiagRec(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 3 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER form");
            }
            this.startingFragment = new FragmentSyntax(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 4 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER form");
            }
            this.intermediateFragment = new FragmentSyntax(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 5 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER form");
            }
            this.finalFragment = new FragmentSyntax(tagwrapper.elementAt(0), true);
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding[] enc;
        BERConstructed chosen = null;
        if (this.retrievalRecord != null) {
            enc = new BEREncoding[]{this.retrievalRecord.berEncode()};
            chosen = new BERConstructed(128, 1, enc);
        }
        if (this.surrogateDiagnostic != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            enc = new BEREncoding[]{this.surrogateDiagnostic.berEncode()};
            chosen = new BERConstructed(128, 2, enc);
        }
        if (this.startingFragment != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            enc = new BEREncoding[]{this.startingFragment.berEncode()};
            chosen = new BERConstructed(128, 3, enc);
        }
        if (this.intermediateFragment != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            enc = new BEREncoding[]{this.intermediateFragment.berEncode()};
            chosen = new BERConstructed(128, 4, enc);
        }
        if (this.finalFragment != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            enc = new BEREncoding[]{this.finalFragment.berEncode()};
            chosen = new BERConstructed(128, 5, enc);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.retrievalRecord != null) {
            found = true;
            str.append("retrievalRecord ");
            str.append(this.retrievalRecord);
        }
        if (this.surrogateDiagnostic != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: surrogateDiagnostic> ");
            }
            found = true;
            str.append("surrogateDiagnostic ");
            str.append((Object)this.surrogateDiagnostic);
        }
        if (this.startingFragment != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: startingFragment> ");
            }
            found = true;
            str.append("startingFragment ");
            str.append((Object)this.startingFragment);
        }
        if (this.intermediateFragment != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: intermediateFragment> ");
            }
            found = true;
            str.append("intermediateFragment ");
            str.append((Object)this.intermediateFragment);
        }
        if (this.finalFragment != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: finalFragment> ");
            }
            str.append("finalFragment ");
            str.append((Object)this.finalFragment);
        }
        str.append("}");
        return str.toString();
    }
}

