/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OccurrenceByAttributes1;

public final class OccurrenceByAttributes
extends ASN1Any {
    public OccurrenceByAttributes1[] value;

    public OccurrenceByAttributes(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("OccurrenceByAttributes: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        this.value = new OccurrenceByAttributes1[numParts];
        for (int p = 0; p < numParts; ++p) {
            this.value[p] = new OccurrenceByAttributes1(berConstructed.elementAt(p), true);
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        BERConstructed[] fields = new BERConstructed[this.value.length];
        for (int p = 0; p < this.value.length; ++p) {
            fields[p] = this.value[p].berEncode();
        }
        return new BERConstructed(tagType, tag, (BEREncoding[])fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        for (int p = 0; p < this.value.length; ++p) {
            str.append((Object)this.value[p]);
        }
        str.append("}");
        return str.toString();
    }
}

