/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AttributeList;
import org.xbib.z3950.common.v3.OccurrenceByAttributesOccurrences;
import org.xbib.z3950.common.v3.OtherInformation;

public final class OccurrenceByAttributes1
extends ASN1Any {
    public AttributeList s_attributes;
    public OccurrenceByAttributesOccurrences s_occurrences;
    public OtherInformation s_otherOccurInfo;

    public OccurrenceByAttributes1(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed tagged;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("OccurrenceByAttributes1: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("OccurrenceByAttributes1: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() != 1 || p.getTagType() != 128) {
            throw new ASN1EncodingException("OccurrenceByAttributes1: bad tag in s_attributes\n");
        }
        try {
            tagged = (BERConstructed)p;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("OccurrenceByAttributes1: bad BER encoding: s_attributes tag bad\n");
        }
        if (tagged.numberComponents() != 1) {
            throw new ASN1EncodingException("OccurrenceByAttributes1: bad BER encoding: s_attributes tag bad\n");
        }
        this.s_attributes = new AttributeList(tagged.elementAt(0), true);
        this.s_occurrences = null;
        this.s_otherOccurInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_occurrences = new OccurrenceByAttributesOccurrences(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_occurrences = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherOccurInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherOccurInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("OccurrenceByAttributes1: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.s_occurrences != null) {
            ++numFields;
        }
        if (this.s_otherOccurInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        BEREncoding[] enc = new BEREncoding[]{this.s_attributes.berEncode()};
        fields[x++] = new BERConstructed(128, 1, enc);
        if (this.s_occurrences != null) {
            fields[x++] = this.s_occurrences.berEncode();
        }
        if (this.s_otherOccurInfo != null) {
            fields[x] = this.s_otherOccurInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("attributes ");
        str.append((Object)this.s_attributes);
        ++outputted;
        if (this.s_occurrences != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("occurrences ");
            str.append((Object)this.s_occurrences);
            ++outputted;
        }
        if (this.s_otherOccurInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherOccurInfo ");
            str.append((Object)this.s_otherOccurInfo);
        }
        str.append("}");
        return str.toString();
    }
}

