/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OccurrenceByAttributesOccurrencesByDatabase;

public final class OccurrenceByAttributesOccurrences
extends ASN1Any {
    public ASN1Integer c_global;
    public OccurrenceByAttributesOccurrencesByDatabase[] c_byDatabase;

    public OccurrenceByAttributesOccurrences(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_global = null;
        this.c_byDatabase = null;
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER form");
            }
            this.c_global = new ASN1Integer(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 3 && ber.getTagType() == 128) {
            BERConstructed berConstructed;
            BEREncoding ber_data = ber;
            try {
                berConstructed = (BERConstructed)ber_data;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            int numParts = berConstructed.numberComponents();
            this.c_byDatabase = new OccurrenceByAttributesOccurrencesByDatabase[numParts];
            for (int p = 0; p < numParts; ++p) {
                this.c_byDatabase[p] = new OccurrenceByAttributesOccurrencesByDatabase(berConstructed.elementAt(p), true);
            }
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BERConstructed chosen = null;
        if (this.c_global != null) {
            BEREncoding[] enc = new BEREncoding[]{this.c_global.berEncode()};
            chosen = new BERConstructed(128, 2, enc);
        }
        if (this.c_byDatabase != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] f2 = new BEREncoding[this.c_byDatabase.length];
            for (int p = 0; p < this.c_byDatabase.length; ++p) {
                f2[p] = this.c_byDatabase[p].berEncode();
            }
            chosen = new BERConstructed(128, 3, f2);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_global != null) {
            found = true;
            str.append("global ");
            str.append(this.c_global);
        }
        if (this.c_byDatabase != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: byDatabase> ");
            }
            str.append("byDatabase ");
            str.append("{");
            for (int p = 0; p < this.c_byDatabase.length; ++p) {
                str.append((Object)this.c_byDatabase[p]);
            }
            str.append("}");
        }
        str.append("}");
        return str.toString();
    }
}

