/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DatabaseName;
import org.xbib.z3950.common.v3.OtherInformation;

public final class OccurrenceByAttributesOccurrencesByDatabase
extends ASN1Any {
    public DatabaseName s_db;
    public ASN1Integer s_num;
    public OtherInformation s_otherDbInfo;

    public OccurrenceByAttributesOccurrencesByDatabase(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        this.s_db = new DatabaseName(p, true);
        this.s_num = null;
        this.s_otherDbInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            this.s_num = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherDbInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherDbInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.s_num != null) {
            ++numFields;
        }
        if (this.s_otherDbInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        fields[x++] = this.s_db.berEncode();
        if (this.s_num != null) {
            fields[x++] = this.s_num.berEncode(128, 1);
        }
        if (this.s_otherDbInfo != null) {
            fields[x] = this.s_otherDbInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("db ");
        str.append((Object)this.s_db);
        ++outputted;
        if (this.s_num != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("num ");
            str.append(this.s_num);
            ++outputted;
        }
        if (this.s_otherDbInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherDbInfo ");
            str.append((Object)this.s_otherDbInfo);
        }
        str.append("}");
        return str.toString();
    }
}

