/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AttributesPlusTerm;
import org.xbib.z3950.common.v3.ResultSetId;
import org.xbib.z3950.common.v3.ResultSetPlusAttributes;

public final class Operand
extends ASN1Any {
    public AttributesPlusTerm attrTerm;
    public ResultSetId resultSet;
    public ResultSetPlusAttributes resultAttr;

    public Operand() {
    }

    public Operand(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.attrTerm = null;
        this.resultSet = null;
        this.resultAttr = null;
        try {
            this.attrTerm = new AttributesPlusTerm(ber, checkTag);
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            try {
                this.resultSet = new ResultSetId(ber, checkTag);
                return;
            }
            catch (ASN1Exception aSN1Exception2) {
                try {
                    this.resultAttr = new ResultSetPlusAttributes(ber, checkTag);
                    return;
                }
                catch (ASN1Exception aSN1Exception3) {
                    throw new ASN1Exception("bad BER encoding: choice not matched");
                }
            }
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.attrTerm != null) {
            chosen = this.attrTerm.berEncode();
        }
        if (this.resultSet != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.resultSet.berEncode();
        }
        if (this.resultAttr != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.resultAttr.berEncode();
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.attrTerm != null) {
            found = true;
            str.append("attrTerm ");
            str.append((Object)this.attrTerm);
        }
        if (this.resultSet != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: resultSet> ");
            }
            found = true;
            str.append("resultSet ");
            str.append((Object)this.resultSet);
        }
        if (this.resultAttr != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: resultAttr> ");
            }
            str.append("resultAttr ");
            str.append((Object)this.resultAttr);
        }
        str.append("}");
        return str.toString();
    }
}

