/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.InternationalString;

public final class OtherInformationInformation
extends ASN1Any {
    public InternationalString c_characterInfo;
    public ASN1OctetString c_binaryInfo;
    public ASN1External c_externallyDefinedInfo;
    public ASN1ObjectIdentifier c_oid;

    public OtherInformationInformation(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_characterInfo = null;
        this.c_binaryInfo = null;
        this.c_externallyDefinedInfo = null;
        this.c_oid = null;
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            this.c_characterInfo = new InternationalString(ber, false);
            return;
        }
        if (ber.getTag() == 3 && ber.getTagType() == 128) {
            this.c_binaryInfo = new ASN1OctetString(ber, false);
            return;
        }
        if (ber.getTag() == 4 && ber.getTagType() == 128) {
            this.c_externallyDefinedInfo = new ASN1External(ber, false);
            return;
        }
        if (ber.getTag() == 5 && ber.getTagType() == 128) {
            this.c_oid = new ASN1ObjectIdentifier(ber, false);
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.c_characterInfo != null) {
            chosen = this.c_characterInfo.berEncode(128, 2);
        }
        if (this.c_binaryInfo != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_binaryInfo.berEncode(128, 3);
        }
        if (this.c_externallyDefinedInfo != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_externallyDefinedInfo.berEncode(128, 4);
        }
        if (this.c_oid != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_oid.berEncode(128, 5);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_characterInfo != null) {
            found = true;
            str.append("characterInfo ");
            str.append((Object)this.c_characterInfo);
        }
        if (this.c_binaryInfo != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: binaryInfo> ");
            }
            found = true;
            str.append("binaryInfo ");
            str.append(this.c_binaryInfo);
        }
        if (this.c_externallyDefinedInfo != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: externallyDefinedInfo> ");
            }
            found = true;
            str.append("externallyDefinedInfo ");
            str.append(this.c_externallyDefinedInfo);
        }
        if (this.c_oid != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: oid> ");
            }
            found = true;
            str.append("oid ");
            str.append(this.c_oid);
        }
        str.append("}");
        return str.toString();
    }
}

