/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.PresentStatus;
import org.xbib.z3950.common.v3.Records;
import org.xbib.z3950.common.v3.ReferenceId;

public final class PresentResponse
extends ASN1Any {
    public ReferenceId referenceId;
    public ASN1Integer numberOfRecordsReturned;
    public ASN1Integer nextResultSetPosition;
    public PresentStatus presentStatus;
    public Records records;
    public OtherInformation otherInfo;

    public PresentResponse(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("PresentResponse: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 24 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_numberOfRecordsReturned");
        }
        this.numberOfRecordsReturned = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 25 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_nextResultSetPosition\n");
        }
        this.nextResultSetPosition = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.presentStatus = new PresentStatus(p, true);
        this.records = null;
        this.otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.records = new Records(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.records = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 3;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.records != null) {
            ++numFields;
        }
        if (this.otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        fields[x++] = this.numberOfRecordsReturned.berEncode(128, 24);
        fields[x++] = this.nextResultSetPosition.berEncode(128, 25);
        fields[x++] = this.presentStatus.berEncode();
        if (this.records != null) {
            fields[x++] = this.records.berEncode();
        }
        if (this.otherInfo != null) {
            fields[x] = this.otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("numberOfRecordsReturned ");
        str.append(this.numberOfRecordsReturned);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("nextResultSetPosition ");
        str.append(this.nextResultSetPosition);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("presentStatus ");
        str.append((Object)this.presentStatus);
        ++outputted;
        if (this.records != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("records ");
            str.append((Object)this.records);
            ++outputted;
        }
        if (this.otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

