/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.RPNQuery;

public final class Query
extends ASN1Any {
    public ASN1Any c_type_0;
    public RPNQuery c_type_1;
    public ASN1OctetString c_type_2;
    public ASN1OctetString c_type_100;
    public RPNQuery c_type_101;
    public ASN1OctetString c_type_102;

    public Query() {
    }

    public Query(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_type_0 = null;
        this.c_type_1 = null;
        this.c_type_2 = null;
        this.c_type_100 = null;
        this.c_type_101 = null;
        this.c_type_102 = null;
        if (ber.getTag() == 0 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Query: bad BER form\n");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("Query: bad BER form\n");
            }
            this.c_type_0 = new ASN1Any(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            this.c_type_1 = new RPNQuery(ber, false);
            return;
        }
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Query: bad BER form\n");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("Query: bad BER form\n");
            }
            this.c_type_2 = new ASN1OctetString(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 100 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Query: bad BER form\n");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("Query: bad BER form\n");
            }
            this.c_type_100 = new ASN1OctetString(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 101 && ber.getTagType() == 128) {
            this.c_type_101 = new RPNQuery(ber, false);
            return;
        }
        if (ber.getTag() == 102 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Query: bad BER form\n");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("Query: bad BER form\n");
            }
            this.c_type_102 = new ASN1OctetString(tagwrapper.elementAt(0), true);
            return;
        }
        throw new ASN1Exception("Query: bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding[] enc;
        BEREncoding chosen = null;
        if (this.c_type_0 != null) {
            enc = new BEREncoding[]{this.c_type_0.berEncode()};
            chosen = new BERConstructed(128, 0, enc);
        }
        if (this.c_type_1 != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_type_1.berEncode(128, 1);
        }
        if (this.c_type_2 != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            enc = new BEREncoding[]{this.c_type_2.berEncode()};
            chosen = new BERConstructed(128, 2, enc);
        }
        if (this.c_type_100 != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            enc = new BEREncoding[]{this.c_type_100.berEncode()};
            chosen = new BERConstructed(128, 100, enc);
        }
        if (this.c_type_101 != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_type_101.berEncode(128, 101);
        }
        if (this.c_type_102 != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            enc = new BEREncoding[]{this.c_type_102.berEncode()};
            chosen = new BERConstructed(128, 102, enc);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_type_0 != null) {
            found = true;
            str.append("type-0 ");
            str.append(this.c_type_0);
        }
        if (this.c_type_1 != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: type-1> ");
            }
            found = true;
            str.append("type-1 ");
            str.append((Object)this.c_type_1);
        }
        if (this.c_type_2 != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: type-2> ");
            }
            found = true;
            str.append("type-2 ");
            str.append(this.c_type_2);
        }
        if (this.c_type_100 != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: type-100> ");
            }
            found = true;
            str.append("type-100 ");
            str.append(this.c_type_100);
        }
        if (this.c_type_101 != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: type-101> ");
            }
            found = true;
            str.append("type-101 ");
            str.append((Object)this.c_type_101);
        }
        if (this.c_type_102 != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: type-102> ");
            }
            found = true;
            str.append("type-102 ");
            str.append(this.c_type_102);
        }
        str.append("}");
        return str.toString();
    }
}

