/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.Operand;
import org.xbib.z3950.common.v3.RPNStructureRpnRpnOp;

public final class RPNStructure
extends ASN1Any {
    public Operand c_op;
    public RPNStructureRpnRpnOp c_rpnRpnOp;

    public RPNStructure() {
    }

    public RPNStructure(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_op = null;
        this.c_rpnRpnOp = null;
        if (ber.getTag() == 0 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("RPNStructure: bad BER form\n");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("RPNStructure: bad BER form\n");
            }
            this.c_op = new Operand(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            this.c_rpnRpnOp = new RPNStructureRpnRpnOp(ber, false);
            return;
        }
        throw new ASN1Exception("RPNStructure: bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.c_op != null) {
            BEREncoding[] enc = new BEREncoding[]{this.c_op.berEncode()};
            chosen = new BERConstructed(128, 0, enc);
        }
        if (this.c_rpnRpnOp != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_rpnRpnOp.berEncode(128, 1);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("RPNStructure: cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_op != null) {
            found = true;
            str.append("op ");
            str.append((Object)this.c_op);
        }
        if (this.c_rpnRpnOp != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: rpnRpnOp> ");
            }
            str.append("rpnRpnOp ");
            str.append((Object)this.c_rpnRpnOp);
        }
        str.append("}");
        return str.toString();
    }
}

