/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;

public final class Range
extends ASN1Any {
    public ASN1Integer s_startingPosition;
    public ASN1Integer s_numberOfRecords;

    public Range(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("Range: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("Range: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() != 1 || p.getTagType() != 128) {
            throw new ASN1EncodingException("Range: bad tag in s_startingPosition\n");
        }
        this.s_startingPosition = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("Range: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 2 || p.getTagType() != 128) {
            throw new ASN1EncodingException("Range: bad tag in s_numberOfRecords\n");
        }
        this.s_numberOfRecords = new ASN1Integer(p, false);
        if (++part < numParts) {
            throw new ASN1Exception("Range: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 2;
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        fields[x++] = this.s_startingPosition.berEncode(128, 1);
        fields[x] = this.s_numberOfRecords.berEncode(128, 2);
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("startingPosition ");
        str.append(this.s_startingPosition);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("numberOfRecords ");
        str.append(this.s_numberOfRecords);
        str.append("}");
        return str.toString();
    }
}

