/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Boolean;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;
import org.xbib.z3950.common.v3.ResourceReport;

public final class ResourceControlRequest
extends ASN1Any {
    public static final int E_subset = 1;
    public static final int E_interim = 2;
    public static final int E_none = 3;
    public ReferenceId s_referenceId;
    public ASN1Boolean s_suspendedFlag;
    public ResourceReport s_resourceReport;
    public ASN1Integer s_partialResultsAvailable;
    public ASN1Boolean s_responseRequired;
    public ASN1Boolean s_triggeredRequestFlag;
    public OtherInformation s_otherInfo;

    public ResourceControlRequest() {
    }

    public ResourceControlRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.s_referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 39 && p.getTagType() == 128) {
            this.s_suspendedFlag = new ASN1Boolean(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 40 && p.getTagType() == 128) {
            BERConstructed tagged;
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: s_resourceReport tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: s_resourceReport tag bad");
            }
            this.s_resourceReport = new ResourceReport(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 41 && p.getTagType() == 128) {
            this.s_partialResultsAvailable = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 42 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_responseRequired");
        }
        this.s_responseRequired = new ASN1Boolean(p, false);
        this.s_triggeredRequestFlag = null;
        this.s_otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 43 && p.getTagType() == 128) {
            this.s_triggeredRequestFlag = new ASN1Boolean(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.s_referenceId != null) {
            ++numFields;
        }
        if (this.s_suspendedFlag != null) {
            ++numFields;
        }
        if (this.s_resourceReport != null) {
            ++numFields;
        }
        if (this.s_partialResultsAvailable != null) {
            ++numFields;
        }
        if (this.s_triggeredRequestFlag != null) {
            ++numFields;
        }
        if (this.s_otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_referenceId != null) {
            fields[x++] = this.s_referenceId.berEncode();
        }
        if (this.s_suspendedFlag != null) {
            fields[x++] = this.s_suspendedFlag.berEncode(128, 39);
        }
        if (this.s_resourceReport != null) {
            BEREncoding[] enc = new BEREncoding[]{this.s_resourceReport.berEncode()};
            fields[x++] = new BERConstructed(128, 40, enc);
        }
        if (this.s_partialResultsAvailable != null) {
            fields[x++] = this.s_partialResultsAvailable.berEncode(128, 41);
        }
        fields[x++] = this.s_responseRequired.berEncode(128, 42);
        if (this.s_triggeredRequestFlag != null) {
            fields[x++] = this.s_triggeredRequestFlag.berEncode(128, 43);
        }
        if (this.s_otherInfo != null) {
            fields[x] = this.s_otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.s_referenceId);
            ++outputted;
        }
        if (this.s_suspendedFlag != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("suspendedFlag ");
            str.append(this.s_suspendedFlag);
            ++outputted;
        }
        if (this.s_resourceReport != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("resourceReport ");
            str.append((Object)this.s_resourceReport);
            ++outputted;
        }
        if (this.s_partialResultsAvailable != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("partialResultsAvailable ");
            str.append(this.s_partialResultsAvailable);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("responseRequired ");
        str.append(this.s_responseRequired);
        ++outputted;
        if (this.s_triggeredRequestFlag != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("triggeredRequestFlag ");
            str.append(this.s_triggeredRequestFlag);
            ++outputted;
        }
        if (this.s_otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.s_otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

