/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;
import org.xbib.z3950.common.v3.ResourceReportId;

public final class ResourceReportRequest
extends ASN1Any {
    public ReferenceId s_referenceId;
    public ReferenceId s_opId;
    public ResourceReportId s_prefResourceReportFormat;
    public OtherInformation s_otherInfo;

    public ResourceReportRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        this.s_referenceId = null;
        this.s_opId = null;
        this.s_prefResourceReportFormat = null;
        this.s_otherInfo = null;
        if (numParts <= part) {
            return;
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.s_referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_referenceId = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 210 && p.getTagType() == 128) {
            this.s_opId = new ReferenceId(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 49 && p.getTagType() == 128) {
            this.s_prefResourceReportFormat = new ResourceReportId(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 0;
        if (this.s_referenceId != null) {
            ++numFields;
        }
        if (this.s_opId != null) {
            ++numFields;
        }
        if (this.s_prefResourceReportFormat != null) {
            ++numFields;
        }
        if (this.s_otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_referenceId != null) {
            fields[x++] = this.s_referenceId.berEncode();
        }
        if (this.s_opId != null) {
            fields[x++] = this.s_opId.berEncode(128, 210);
        }
        if (this.s_prefResourceReportFormat != null) {
            fields[x++] = this.s_prefResourceReportFormat.berEncode(128, 49);
        }
        if (this.s_otherInfo != null) {
            fields[x] = this.s_otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.s_referenceId);
            ++outputted;
        }
        if (this.s_opId != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("opId ");
            str.append((Object)this.s_opId);
            ++outputted;
        }
        if (this.s_prefResourceReportFormat != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("prefResourceReportFormat ");
            str.append((Object)this.s_prefResourceReportFormat);
            ++outputted;
        }
        if (this.s_otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.s_otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

