/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AttributeList;
import org.xbib.z3950.common.v3.ResultSetId;

public final class ResultSetPlusAttributes
extends ASN1Any {
    public ResultSetId s_resultSet;
    public AttributeList s_attributes;

    public ResultSetPlusAttributes(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        if (checkTag && (ber.getTag() != 214 || ber.getTagType() != 128)) {
            throw new ASN1EncodingException("bad BER: tag=" + ber.getTag() + " expected 214");
        }
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        this.s_resultSet = new ResultSetId(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.s_attributes = new AttributeList(p, true);
        if (++part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(128, 214);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 2;
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        fields[x++] = this.s_resultSet.berEncode();
        fields[x] = this.s_attributes.berEncode();
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("resultSet ");
        str.append((Object)this.s_resultSet);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("attributes ");
        str.append((Object)this.s_attributes);
        str.append("}");
        return str.toString();
    }
}

