/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AttributeSetId;
import org.xbib.z3950.common.v3.AttributesPlusTerm;
import org.xbib.z3950.common.v3.DatabaseName;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;

public final class ScanRequest
extends ASN1Any {
    public ReferenceId referenceId;
    public DatabaseName[] databaseNames;
    public AttributeSetId attributeSet;
    public AttributesPlusTerm termListAndStartPoint;
    public ASN1Integer stepSize;
    public ASN1Integer numberOfTermsRequested;
    public ASN1Integer preferredPositionInResponse;
    public OtherInformation otherInfo;

    public ScanRequest() {
    }

    public ScanRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("ScanRequest: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("ScanRequest: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 3 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_databaseNames");
        }
        try {
            BERConstructed cons = (BERConstructed)p;
            int parts = cons.numberComponents();
            this.databaseNames = new DatabaseName[parts];
            for (int n = 0; n < parts; ++n) {
                this.databaseNames[n] = new DatabaseName(cons.elementAt(n), true);
            }
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER");
        }
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        try {
            this.attributeSet = new AttributeSetId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.attributeSet = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.termListAndStartPoint = new AttributesPlusTerm(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 5 && p.getTagType() == 128) {
            this.stepSize = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 6 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_numberOfTermsRequested");
        }
        this.numberOfTermsRequested = new ASN1Integer(p, false);
        this.preferredPositionInResponse = null;
        this.otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 7 && p.getTagType() == 128) {
            this.preferredPositionInResponse = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 3;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.attributeSet != null) {
            ++numFields;
        }
        if (this.stepSize != null) {
            ++numFields;
        }
        if (this.preferredPositionInResponse != null) {
            ++numFields;
        }
        if (this.otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        BEREncoding[] f2 = new BEREncoding[this.databaseNames.length];
        for (int p = 0; p < this.databaseNames.length; ++p) {
            f2[p] = this.databaseNames[p].berEncode();
        }
        fields[x++] = new BERConstructed(128, 3, f2);
        if (this.attributeSet != null) {
            fields[x++] = this.attributeSet.berEncode();
        }
        fields[x++] = this.termListAndStartPoint.berEncode();
        if (this.stepSize != null) {
            fields[x++] = this.stepSize.berEncode(128, 5);
        }
        fields[x++] = this.numberOfTermsRequested.berEncode(128, 6);
        if (this.preferredPositionInResponse != null) {
            fields[x++] = this.preferredPositionInResponse.berEncode(128, 7);
        }
        if (this.otherInfo != null) {
            fields[x] = this.otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("databaseNames ");
        str.append("{");
        for (int p = 0; p < this.databaseNames.length; ++p) {
            if (p != 0) {
                str.append(", ");
            }
            str.append((Object)this.databaseNames[p]);
        }
        str.append("}");
        ++outputted;
        if (this.attributeSet != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("attributeSet ");
            str.append((Object)this.attributeSet);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("termListAndStartPoint ");
        str.append((Object)this.termListAndStartPoint);
        ++outputted;
        if (this.stepSize != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("stepSize ");
            str.append(this.stepSize);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("numberOfTermsRequested ");
        str.append(this.numberOfTermsRequested);
        ++outputted;
        if (this.preferredPositionInResponse != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("preferredPositionInResponse ");
            str.append(this.preferredPositionInResponse);
            ++outputted;
        }
        if (this.otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

