/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AttributeSetId;
import org.xbib.z3950.common.v3.ListEntries;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;

public final class ScanResponse
extends ASN1Any {
    public static final int E_success = 0;
    public static final int E_partial_1 = 1;
    public static final int E_partial_2 = 2;
    public static final int E_partial_3 = 3;
    public static final int E_partial_4 = 4;
    public static final int E_partial_5 = 5;
    public static final int E_failure = 6;
    public ReferenceId referenceId;
    public ASN1Integer stepSize;
    public ASN1Integer scanStatus;
    public ASN1Integer numberOfEntriesReturned;
    public ASN1Integer positionOfTerm;
    public ListEntries entries;
    public AttributeSetId attributeSet;
    public OtherInformation otherInfo;

    public ScanResponse(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 3 && p.getTagType() == 128) {
            this.stepSize = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 4 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in scanStatus");
        }
        this.scanStatus = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 5 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in numberOfEntriesReturned");
        }
        this.numberOfEntriesReturned = new ASN1Integer(p, false);
        this.positionOfTerm = null;
        this.entries = null;
        this.attributeSet = null;
        this.otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 6 && p.getTagType() == 128) {
            this.positionOfTerm = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 7 && p.getTagType() == 128) {
            this.entries = new ListEntries(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 8 && p.getTagType() == 128) {
            this.attributeSet = new AttributeSetId(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 2;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.stepSize != null) {
            ++numFields;
        }
        if (this.positionOfTerm != null) {
            ++numFields;
        }
        if (this.entries != null) {
            ++numFields;
        }
        if (this.attributeSet != null) {
            ++numFields;
        }
        if (this.otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        if (this.stepSize != null) {
            fields[x++] = this.stepSize.berEncode(128, 3);
        }
        fields[x++] = this.scanStatus.berEncode(128, 4);
        fields[x++] = this.numberOfEntriesReturned.berEncode(128, 5);
        if (this.positionOfTerm != null) {
            fields[x++] = this.positionOfTerm.berEncode(128, 6);
        }
        if (this.entries != null) {
            fields[x++] = this.entries.berEncode(128, 7);
        }
        if (this.attributeSet != null) {
            fields[x++] = this.attributeSet.berEncode(128, 8);
        }
        if (this.otherInfo != null) {
            fields[x] = this.otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (this.stepSize != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("stepSize ");
            str.append(this.stepSize);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("scanStatus ");
        str.append(this.scanStatus);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("numberOfEntriesReturned ");
        str.append(this.numberOfEntriesReturned);
        ++outputted;
        if (this.positionOfTerm != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("positionOfTerm ");
            str.append(this.positionOfTerm);
            ++outputted;
        }
        if (this.entries != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("entries ");
            str.append((Object)this.entries);
            ++outputted;
        }
        if (this.attributeSet != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("attributeSet ");
            str.append((Object)this.attributeSet);
            ++outputted;
        }
        if (this.otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

