/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Boolean;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DatabaseName;
import org.xbib.z3950.common.v3.ElementSetNames;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.Query;
import org.xbib.z3950.common.v3.ReferenceId;

public final class SearchRequest
extends ASN1Any {
    public ReferenceId referenceId;
    public ASN1Integer smallSetUpperBound;
    public ASN1Integer largeSetLowerBound;
    public ASN1Integer mediumSetPresentNumber;
    public ASN1Boolean replaceIndicator;
    public InternationalString resultSetName;
    public DatabaseName[] databaseNames;
    private ElementSetNames smallSetElementSetNames;
    private ElementSetNames mediumSetElementSetNames;
    private ASN1ObjectIdentifier preferredRecordSyntax;
    public Query query;
    private OtherInformation additionalSearchInfo;
    public OtherInformation otherInfo;

    public SearchRequest() {
    }

    public SearchRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed tagged;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 13 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_smallSetUpperBound");
        }
        this.smallSetUpperBound = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 14 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_largeSetLowerBound");
        }
        this.largeSetLowerBound = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 15 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_mediumSetPresentNumber");
        }
        this.mediumSetPresentNumber = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 16 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_replaceIndicator");
        }
        this.replaceIndicator = new ASN1Boolean(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 17 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_resultSetName");
        }
        this.resultSetName = new InternationalString(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 18 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_databaseNames");
        }
        try {
            BERConstructed cons = (BERConstructed)p;
            int parts = cons.numberComponents();
            this.databaseNames = new DatabaseName[parts];
            for (int n = 0; n < parts; ++n) {
                this.databaseNames[n] = new DatabaseName(cons.elementAt(n), true);
            }
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER");
        }
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 100 && p.getTagType() == 128) {
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: s_smallSetElementSetNames tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: s_smallSetElementSetNames tag bad");
            }
            this.smallSetElementSetNames = new ElementSetNames(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 101 && p.getTagType() == 128) {
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: mediumSetElementSetNames tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: mediumSetElementSetNames tag bad");
            }
            this.mediumSetElementSetNames = new ElementSetNames(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 104 && p.getTagType() == 128) {
            this.preferredRecordSyntax = new ASN1ObjectIdentifier(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 21 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in query");
        }
        try {
            tagged = (BERConstructed)p;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER encoding: query tag bad");
        }
        if (tagged.numberComponents() != 1) {
            throw new ASN1EncodingException("bad BER encoding: query tag bad");
        }
        this.query = new Query(tagged.elementAt(0), true);
        this.additionalSearchInfo = null;
        this.otherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 203 && p.getTagType() == 128) {
            this.additionalSearchInfo = new OtherInformation(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        BEREncoding[] enc;
        int numFields = 7;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.smallSetElementSetNames != null) {
            ++numFields;
        }
        if (this.mediumSetElementSetNames != null) {
            ++numFields;
        }
        if (this.preferredRecordSyntax != null) {
            ++numFields;
        }
        if (this.additionalSearchInfo != null) {
            ++numFields;
        }
        if (this.otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        fields[x++] = this.smallSetUpperBound.berEncode(128, 13);
        fields[x++] = this.largeSetLowerBound.berEncode(128, 14);
        fields[x++] = this.mediumSetPresentNumber.berEncode(128, 15);
        fields[x++] = this.replaceIndicator.berEncode(128, 16);
        fields[x++] = this.resultSetName.berEncode(128, 17);
        BEREncoding[] f2 = new BEREncoding[this.databaseNames.length];
        for (int p = 0; p < this.databaseNames.length; ++p) {
            f2[p] = this.databaseNames[p].berEncode();
        }
        fields[x++] = new BERConstructed(128, 18, f2);
        if (this.smallSetElementSetNames != null) {
            enc = new BEREncoding[]{this.smallSetElementSetNames.berEncode()};
            fields[x++] = new BERConstructed(128, 100, enc);
        }
        if (this.mediumSetElementSetNames != null) {
            enc = new BEREncoding[]{this.mediumSetElementSetNames.berEncode()};
            fields[x++] = new BERConstructed(128, 101, enc);
        }
        if (this.preferredRecordSyntax != null) {
            fields[x++] = this.preferredRecordSyntax.berEncode(128, 104);
        }
        enc = new BEREncoding[]{this.query.berEncode()};
        fields[x++] = new BERConstructed(128, 21, enc);
        if (this.additionalSearchInfo != null) {
            fields[x++] = this.additionalSearchInfo.berEncode(128, 203);
        }
        if (this.otherInfo != null) {
            fields[x] = this.otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("smallSetUpperBound ");
        str.append(this.smallSetUpperBound);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("largeSetLowerBound ");
        str.append(this.largeSetLowerBound);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("mediumSetPresentNumber ");
        str.append(this.mediumSetPresentNumber);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("replaceIndicator ");
        str.append(this.replaceIndicator);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("resultSetName ");
        str.append((Object)this.resultSetName);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("databaseNames ");
        str.append("{");
        for (int p = 0; p < this.databaseNames.length; ++p) {
            if (p != 0) {
                str.append(", ");
            }
            str.append((Object)this.databaseNames[p]);
        }
        str.append("}");
        ++outputted;
        if (this.smallSetElementSetNames != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("smallSetElementSetNames ");
            str.append((Object)this.smallSetElementSetNames);
            ++outputted;
        }
        if (this.mediumSetElementSetNames != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("mediumSetElementSetNames ");
            str.append((Object)this.mediumSetElementSetNames);
            ++outputted;
        }
        if (this.preferredRecordSyntax != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("preferredRecordSyntax ");
            str.append(this.preferredRecordSyntax);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("query ");
        str.append((Object)this.query);
        ++outputted;
        if (this.additionalSearchInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("additionalSearchInfo ");
            str.append((Object)this.additionalSearchInfo);
            ++outputted;
        }
        if (this.otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

