/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Boolean;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.PresentStatus;
import org.xbib.z3950.common.v3.Records;
import org.xbib.z3950.common.v3.ReferenceId;

public final class SearchResponse
extends ASN1Any {
    public static final int E_subset = 1;
    public static final int E_interim = 2;
    public static final int E_none = 3;
    public ReferenceId referenceId;
    public ASN1Integer resultCount;
    public ASN1Integer numberOfRecordsReturned;
    public ASN1Integer nextResultSetPosition;
    public ASN1Boolean s_searchStatus;
    public ASN1Integer s_resultSetStatus;
    public PresentStatus s_presentStatus;
    public Records s_records;
    public OtherInformation s_additionalSearchInfo;
    public OtherInformation s_otherInfo;

    public SearchResponse(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 23 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_resultCount");
        }
        this.resultCount = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 24 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_numberOfRecordsReturned");
        }
        this.numberOfRecordsReturned = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 25 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_nextResultSetPosition");
        }
        this.nextResultSetPosition = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 22 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_searchStatus");
        }
        this.s_searchStatus = new ASN1Boolean(p, false);
        ++part;
        this.s_resultSetStatus = null;
        this.s_presentStatus = null;
        this.s_records = null;
        this.s_additionalSearchInfo = null;
        this.s_otherInfo = null;
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 26 && p.getTagType() == 128) {
            this.s_resultSetStatus = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_presentStatus = new PresentStatus(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_presentStatus = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_records = new Records(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_records = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 203 && p.getTagType() == 128) {
            this.s_additionalSearchInfo = new OtherInformation(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.s_otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.s_otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 4;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.s_resultSetStatus != null) {
            ++numFields;
        }
        if (this.s_presentStatus != null) {
            ++numFields;
        }
        if (this.s_records != null) {
            ++numFields;
        }
        if (this.s_additionalSearchInfo != null) {
            ++numFields;
        }
        if (this.s_otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        fields[x++] = this.resultCount.berEncode(128, 23);
        fields[x++] = this.numberOfRecordsReturned.berEncode(128, 24);
        fields[x++] = this.nextResultSetPosition.berEncode(128, 25);
        fields[x++] = this.s_searchStatus.berEncode(128, 22);
        if (this.s_resultSetStatus != null) {
            fields[x++] = this.s_resultSetStatus.berEncode(128, 26);
        }
        if (this.s_presentStatus != null) {
            fields[x++] = this.s_presentStatus.berEncode();
        }
        if (this.s_records != null) {
            fields[x++] = this.s_records.berEncode();
        }
        if (this.s_additionalSearchInfo != null) {
            fields[x++] = this.s_additionalSearchInfo.berEncode(128, 203);
        }
        if (this.s_otherInfo != null) {
            fields[x] = this.s_otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("resultCount ");
        str.append(this.resultCount);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("numberOfRecordsReturned ");
        str.append(this.numberOfRecordsReturned);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("nextResultSetPosition ");
        str.append(this.nextResultSetPosition);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("searchStatus ");
        str.append(this.s_searchStatus);
        ++outputted;
        if (this.s_resultSetStatus != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("resultSetStatus ");
            str.append(this.s_resultSetStatus);
            ++outputted;
        }
        if (this.s_presentStatus != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("presentStatus ");
            str.append((Object)this.s_presentStatus);
            ++outputted;
        }
        if (this.s_records != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("records ");
            str.append((Object)this.s_records);
            ++outputted;
        }
        if (this.s_additionalSearchInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("additionalSearchInfo ");
            str.append((Object)this.s_additionalSearchInfo);
            ++outputted;
        }
        if (this.s_otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.s_otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

