/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.SortElementDatabaseSpecific;
import org.xbib.z3950.common.v3.SortKey;

public final class SortElement
extends ASN1Any {
    public SortKey c_generic;
    public SortElementDatabaseSpecific[] c_datbaseSpecific;

    public SortElement(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_generic = null;
        this.c_datbaseSpecific = null;
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER form");
            }
            this.c_generic = new SortKey(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            BERConstructed berConstructed;
            BEREncoding ber_data = ber;
            try {
                berConstructed = (BERConstructed)ber_data;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            int numParts = berConstructed.numberComponents();
            this.c_datbaseSpecific = new SortElementDatabaseSpecific[numParts];
            for (int p = 0; p < numParts; ++p) {
                this.c_datbaseSpecific[p] = new SortElementDatabaseSpecific(berConstructed.elementAt(p), true);
            }
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BERConstructed chosen = null;
        if (this.c_generic != null) {
            BEREncoding[] enc = new BEREncoding[]{this.c_generic.berEncode()};
            chosen = new BERConstructed(128, 1, enc);
        }
        if (this.c_datbaseSpecific != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] f2 = new BEREncoding[this.c_datbaseSpecific.length];
            for (int p = 0; p < this.c_datbaseSpecific.length; ++p) {
                f2[p] = this.c_datbaseSpecific[p].berEncode();
            }
            chosen = new BERConstructed(128, 2, f2);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_generic != null) {
            found = true;
            str.append("generic ");
            str.append((Object)this.c_generic);
        }
        if (this.c_datbaseSpecific != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: datbaseSpecific> ");
            }
            found = true;
            str.append("datbaseSpecific ");
            str.append("{");
            for (int p = 0; p < this.c_datbaseSpecific.length; ++p) {
                str.append((Object)this.c_datbaseSpecific[p]);
            }
            str.append("}");
        }
        str.append("}");
        return str.toString();
    }
}

