/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.SortKeySortAttributes;
import org.xbib.z3950.common.v3.Specification;

public final class SortKey
extends ASN1Any {
    public InternationalString c_sortfield;
    public Specification c_elementSpec;
    public SortKeySortAttributes c_sortAttributes;

    public SortKey(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_sortfield = null;
        this.c_elementSpec = null;
        this.c_sortAttributes = null;
        if (ber.getTag() == 0 && ber.getTagType() == 128) {
            this.c_sortfield = new InternationalString(ber, false);
            return;
        }
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            this.c_elementSpec = new Specification(ber, false);
            return;
        }
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            this.c_sortAttributes = new SortKeySortAttributes(ber, false);
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.c_sortfield != null) {
            chosen = this.c_sortfield.berEncode(128, 0);
        }
        if (this.c_elementSpec != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_elementSpec.berEncode(128, 1);
        }
        if (this.c_sortAttributes != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_sortAttributes.berEncode(128, 2);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("SortKey: cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_sortfield != null) {
            found = true;
            str.append("sortfield ");
            str.append((Object)this.c_sortfield);
        }
        if (this.c_elementSpec != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: elementSpec> ");
            }
            found = true;
            str.append("elementSpec ");
            str.append((Object)this.c_elementSpec);
        }
        if (this.c_sortAttributes != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: sortAttributes> ");
            }
            found = true;
            str.append("sortAttributes ");
            str.append((Object)this.c_sortAttributes);
        }
        str.append("}");
        return str.toString();
    }
}

