/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.SortElement;
import org.xbib.z3950.common.v3.SortKeySpecMissingValueAction;

public final class SortKeySpec
extends ASN1Any {
    public static final int E_ascending = 0;
    public static final int E_descending = 1;
    public static final int E_ascendingByFrequency = 3;
    public static final int E_descendingByfrequency = 4;
    public static final int E_caseSensitive = 0;
    public static final int E_caseInsensitive = 1;
    public SortElement s_sortElement;
    public ASN1Integer s_sortRelation;
    public ASN1Integer s_caseSensitivity;
    public SortKeySpecMissingValueAction s_missingValueAction;

    public SortKeySpec(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        this.s_sortElement = new SortElement(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 1 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_sortRelation");
        }
        this.s_sortRelation = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 2 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_caseSensitivity");
        }
        this.s_caseSensitivity = new ASN1Integer(p, false);
        this.s_missingValueAction = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 3 && p.getTagType() == 128) {
            BERConstructed tagged;
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: s_missingValueAction tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: s_missingValueAction tag bad");
            }
            this.s_missingValueAction = new SortKeySpecMissingValueAction(tagged.elementAt(0), true);
            ++part;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 3;
        if (this.s_missingValueAction != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        fields[x++] = this.s_sortElement.berEncode();
        fields[x++] = this.s_sortRelation.berEncode(128, 1);
        fields[x++] = this.s_caseSensitivity.berEncode(128, 2);
        if (this.s_missingValueAction != null) {
            BEREncoding[] enc = new BEREncoding[]{this.s_missingValueAction.berEncode()};
            fields[x] = new BERConstructed(128, 3, enc);
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("sortElement ");
        str.append((Object)this.s_sortElement);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("sortRelation ");
        str.append(this.s_sortRelation);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("caseSensitivity ");
        str.append(this.s_caseSensitivity);
        ++outputted;
        if (this.s_missingValueAction != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("missingValueAction ");
            str.append((Object)this.s_missingValueAction);
        }
        str.append("}");
        return str.toString();
    }
}

