/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.SpecificationElementSpec;

public final class Specification
extends ASN1Any {
    public ASN1ObjectIdentifier s_schema;
    public SpecificationElementSpec s_elementSpec;

    public Specification(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        this.s_schema = null;
        this.s_elementSpec = null;
        if (numParts <= part) {
            return;
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            this.s_schema = new ASN1ObjectIdentifier(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 2 && p.getTagType() == 128) {
            BERConstructed tagged;
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: elementSpec tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: elementSpec tag bad");
            }
            this.s_elementSpec = new SpecificationElementSpec(tagged.elementAt(0), true);
            ++part;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 0;
        if (this.s_schema != null) {
            ++numFields;
        }
        if (this.s_elementSpec != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_schema != null) {
            fields[x++] = this.s_schema.berEncode(128, 1);
        }
        if (this.s_elementSpec != null) {
            BEREncoding[] enc = new BEREncoding[]{this.s_elementSpec.berEncode()};
            fields[x] = new BERConstructed(128, 2, enc);
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_schema != null) {
            str.append("schema ");
            str.append(this.s_schema);
            ++outputted;
        }
        if (this.s_elementSpec != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("elementSpec ");
            str.append((Object)this.s_elementSpec);
        }
        str.append("}");
        return str.toString();
    }
}

