/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.ASN1GeneralizedTime;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1Null;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.IntUnit;
import org.xbib.z3950.common.v3.InternationalString;

public final class Term
extends ASN1Any {
    public ASN1OctetString c_general;
    public ASN1Integer c_numeric;
    public InternationalString c_characterString;
    public ASN1ObjectIdentifier c_oid;
    public ASN1GeneralizedTime c_dateTime;
    public ASN1External c_external;
    public IntUnit c_integerAndUnit;
    public ASN1Null c_null;

    public Term() {
    }

    public Term(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_general = null;
        this.c_numeric = null;
        this.c_characterString = null;
        this.c_oid = null;
        this.c_dateTime = null;
        this.c_external = null;
        this.c_integerAndUnit = null;
        this.c_null = null;
        if (ber.getTag() == 45 && ber.getTagType() == 128) {
            this.c_general = new ASN1OctetString(ber, false);
            return;
        }
        if (ber.getTag() == 215 && ber.getTagType() == 128) {
            this.c_numeric = new ASN1Integer(ber, false);
            return;
        }
        if (ber.getTag() == 216 && ber.getTagType() == 128) {
            this.c_characterString = new InternationalString(ber, false);
            return;
        }
        if (ber.getTag() == 217 && ber.getTagType() == 128) {
            this.c_oid = new ASN1ObjectIdentifier(ber, false);
            return;
        }
        if (ber.getTag() == 218 && ber.getTagType() == 128) {
            this.c_dateTime = new ASN1GeneralizedTime(ber, false);
            return;
        }
        if (ber.getTag() == 219 && ber.getTagType() == 128) {
            this.c_external = new ASN1External(ber, false);
            return;
        }
        if (ber.getTag() == 220 && ber.getTagType() == 128) {
            this.c_integerAndUnit = new IntUnit(ber, false);
            return;
        }
        if (ber.getTag() == 221 && ber.getTagType() == 128) {
            this.c_null = new ASN1Null(ber, false);
            return;
        }
        throw new ASN1Exception("Term: bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.c_general != null) {
            chosen = this.c_general.berEncode(128, 45);
        }
        if (this.c_numeric != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_numeric.berEncode(128, 215);
        }
        if (this.c_characterString != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_characterString.berEncode(128, 216);
        }
        if (this.c_oid != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_oid.berEncode(128, 217);
        }
        if (this.c_dateTime != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_dateTime.berEncode(128, 218);
        }
        if (this.c_external != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_external.berEncode(128, 219);
        }
        if (this.c_integerAndUnit != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_integerAndUnit.berEncode(128, 220);
        }
        if (this.c_null != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_null.berEncode(128, 221);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("Term: cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_general != null) {
            found = true;
            str.append("general ");
            str.append(this.c_general);
        }
        if (this.c_numeric != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: numeric> ");
            }
            found = true;
            str.append("numeric ");
            str.append(this.c_numeric);
        }
        if (this.c_characterString != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: characterString> ");
            }
            found = true;
            str.append("characterString ");
            str.append((Object)this.c_characterString);
        }
        if (this.c_oid != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: oid> ");
            }
            found = true;
            str.append("oid ");
            str.append(this.c_oid);
        }
        if (this.c_dateTime != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: dateTime> ");
            }
            found = true;
            str.append("dateTime ");
            str.append(this.c_dateTime);
        }
        if (this.c_external != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: external> ");
            }
            found = true;
            str.append("external ");
            str.append(this.c_external);
        }
        if (this.c_integerAndUnit != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: integerAndUnit> ");
            }
            found = true;
            str.append("integerAndUnit ");
            str.append((Object)this.c_integerAndUnit);
        }
        if (this.c_null != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: null> ");
            }
            found = true;
            str.append("null ");
            str.append(this.c_null);
        }
        str.append("}");
        return str.toString();
    }
}

